// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The action that WAF should take on a web request when it matches a rule's
 * statement. Settings at the web ACL level can override the rule action setting.
 */
class RuleAction private constructor(builder: Builder) {
    /**
     * Instructs WAF to allow the web request.
     */
    val allow: aws.sdk.kotlin.services.wafv2.model.AllowAction? = builder.allow
    /**
     * Instructs WAF to block the web request.
     */
    val block: aws.sdk.kotlin.services.wafv2.model.BlockAction? = builder.block
    /**
     * Instructs WAF to count the web request and allow it.
     */
    val count: aws.sdk.kotlin.services.wafv2.model.CountAction? = builder.count

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RuleAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleAction(")
        append("allow=$allow,")
        append("block=$block,")
        append("count=$count)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allow?.hashCode() ?: 0
        result = 31 * result + (block?.hashCode() ?: 0)
        result = 31 * result + (count?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RuleAction

        if (allow != other.allow) return false
        if (block != other.block) return false
        if (count != other.count) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RuleAction = Builder(this).apply(block).build()

    class Builder {
        /**
         * Instructs WAF to allow the web request.
         */
        var allow: aws.sdk.kotlin.services.wafv2.model.AllowAction? = null
        /**
         * Instructs WAF to block the web request.
         */
        var block: aws.sdk.kotlin.services.wafv2.model.BlockAction? = null
        /**
         * Instructs WAF to count the web request and allow it.
         */
        var count: aws.sdk.kotlin.services.wafv2.model.CountAction? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RuleAction) : this() {
            this.allow = x.allow
            this.block = x.block
            this.count = x.count
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RuleAction = RuleAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.AllowAction] inside the given [block]
         */
        fun allow(block: aws.sdk.kotlin.services.wafv2.model.AllowAction.Builder.() -> kotlin.Unit) {
            this.allow = aws.sdk.kotlin.services.wafv2.model.AllowAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.BlockAction] inside the given [block]
         */
        fun block(block: aws.sdk.kotlin.services.wafv2.model.BlockAction.Builder.() -> kotlin.Unit) {
            this.block = aws.sdk.kotlin.services.wafv2.model.BlockAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.CountAction] inside the given [block]
         */
        fun count(block: aws.sdk.kotlin.services.wafv2.model.CountAction.Builder.() -> kotlin.Unit) {
            this.count = aws.sdk.kotlin.services.wafv2.model.CountAction.invoke(block)
        }
    }
}
