// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A tag associated with an Amazon Web Services resource. Tags are key:value pairs that you can use to
 * categorize and manage your resources, for purposes like billing or other management.
 * Typically, the tag key represents a category, such as "environment", and the tag value
 * represents a specific value within that category, such as "test," "development," or
 * "production". Or you might set the tag key to "customer" and the value to the customer name
 * or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a
 * resource.
 * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule
 * groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF
 * console.
 */
class Tag private constructor(builder: Builder) {
    /**
     * Part of the key:value pair that defines a tag. You can use a tag key to describe a
     * category of information, such as "customer." Tag keys are case-sensitive.
     */
    val key: kotlin.String? = builder.key
    /**
     * Part of the key:value pair that defines a tag. You can use a tag value to describe a
     * specific value within a category, such as "companyA" or "companyB." Tag values are
     * case-sensitive.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.Tag = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Tag(")
        append("key=$key,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Tag

        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.Tag = Builder(this).apply(block).build()

    class Builder {
        /**
         * Part of the key:value pair that defines a tag. You can use a tag key to describe a
         * category of information, such as "customer." Tag keys are case-sensitive.
         */
        var key: kotlin.String? = null
        /**
         * Part of the key:value pair that defines a tag. You can use a tag value to describe a
         * specific value within a category, such as "companyA" or "companyB." Tag values are
         * case-sensitive.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.Tag) : this() {
            this.key = x.key
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.Tag = Tag(this)
    }
}
