// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * In a GetSampledRequests request, the StartTime and
 * EndTime objects specify the time range for which you want WAF to
 * return a sample of web requests.
 * You must specify the times in Coordinated Universal Time (UTC) format. UTC format
 * includes the special designator, Z. For example,
 * "2016-09-27T14:50Z". You can specify any time range in the previous three
 * hours.
 * In a GetSampledRequests response, the StartTime and
 * EndTime objects specify the time range for which WAF actually returned a
 * sample of web requests. WAF gets the specified number of requests from among the first
 * 5,000 requests that your Amazon Web Services resource receives during the specified time period. If your
 * resource receives more than 5,000 requests during that period, WAF stops sampling after
 * the 5,000th request. In that case, EndTime is the time that WAF received the
 * 5,000th request.
 */
class TimeWindow private constructor(builder: Builder) {
    /**
     * The end of the time range from which you want GetSampledRequests to return
     * a sample of the requests that your Amazon Web Services resource received. You must specify the times in
     * Coordinated Universal Time (UTC) format. UTC format includes the special designator,
     * Z. For example, "2016-09-27T14:50Z". You can specify any time
     * range in the previous three hours.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The beginning of the time range from which you want GetSampledRequests to
     * return a sample of the requests that your Amazon Web Services resource received. You must specify the
     * times in Coordinated Universal Time (UTC) format. UTC format includes the special
     * designator, Z. For example, "2016-09-27T14:50Z". You can specify
     * any time range in the previous three hours.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.TimeWindow = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimeWindow(")
        append("endTime=$endTime,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TimeWindow

        if (endTime != other.endTime) return false
        if (startTime != other.startTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.TimeWindow = Builder(this).apply(block).build()

    class Builder {
        /**
         * The end of the time range from which you want GetSampledRequests to return
         * a sample of the requests that your Amazon Web Services resource received. You must specify the times in
         * Coordinated Universal Time (UTC) format. UTC format includes the special designator,
         * Z. For example, "2016-09-27T14:50Z". You can specify any time
         * range in the previous three hours.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The beginning of the time range from which you want GetSampledRequests to
         * return a sample of the requests that your Amazon Web Services resource received. You must specify the
         * times in Coordinated Universal Time (UTC) format. UTC format includes the special
         * designator, Z. For example, "2016-09-27T14:50Z". You can specify
         * any time range in the previous three hours.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.TimeWindow) : this() {
            this.endTime = x.endTime
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.TimeWindow = TimeWindow(this)
    }
}
