// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



class UpdateWebAclRequest private constructor(builder: Builder) {
    /**
     * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.
     * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF in the
     * <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide.
     * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas in the
     * <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide.
     */
    val customResponseBodies: Map<String, CustomResponseBody>? = builder.customResponseBodies
    /**
     * The action to perform if none of the Rules contained in the WebACL match.
     */
    val defaultAction: aws.sdk.kotlin.services.wafv2.model.DefaultAction? = builder.defaultAction
    /**
     * A description of the web ACL that helps with identification.
     */
    val description: kotlin.String? = builder.description
    /**
     * The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    val id: kotlin.String? = builder.id
    /**
     * A token used for optimistic locking. WAF returns a token to your get and list requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like update and delete. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a WAFOptimisticLockException. If this happens, perform another get, and use the new token returned by that operation.
     */
    val lockToken: kotlin.String? = builder.lockToken
    /**
     * The name of the web ACL. You cannot change the name of a web ACL after you create it.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Rule statements used to identify the web requests that you
     * want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching
     * web requests, and parameters that govern how WAF handles them.
     */
    val rules: List<Rule>? = builder.rules
    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     */
    val scope: aws.sdk.kotlin.services.wafv2.model.Scope? = builder.scope
    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    val visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = builder.visibilityConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.UpdateWebAclRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateWebAclRequest(")
        append("customResponseBodies=$customResponseBodies,")
        append("defaultAction=$defaultAction,")
        append("description=$description,")
        append("id=$id,")
        append("lockToken=$lockToken,")
        append("name=$name,")
        append("rules=$rules,")
        append("scope=$scope,")
        append("visibilityConfig=$visibilityConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customResponseBodies?.hashCode() ?: 0
        result = 31 * result + (defaultAction?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lockToken?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (visibilityConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateWebAclRequest

        if (customResponseBodies != other.customResponseBodies) return false
        if (defaultAction != other.defaultAction) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lockToken != other.lockToken) return false
        if (name != other.name) return false
        if (rules != other.rules) return false
        if (scope != other.scope) return false
        if (visibilityConfig != other.visibilityConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.UpdateWebAclRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.
         * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF in the
         * <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide.
         * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas in the
         * <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide.
         */
        var customResponseBodies: Map<String, CustomResponseBody>? = null
        /**
         * The action to perform if none of the Rules contained in the WebACL match.
         */
        var defaultAction: aws.sdk.kotlin.services.wafv2.model.DefaultAction? = null
        /**
         * A description of the web ACL that helps with identification.
         */
        var description: kotlin.String? = null
        /**
         * The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
         */
        var id: kotlin.String? = null
        /**
         * A token used for optimistic locking. WAF returns a token to your get and list requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like update and delete. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a WAFOptimisticLockException. If this happens, perform another get, and use the new token returned by that operation.
         */
        var lockToken: kotlin.String? = null
        /**
         * The name of the web ACL. You cannot change the name of a web ACL after you create it.
         */
        var name: kotlin.String? = null
        /**
         * The Rule statements used to identify the web requests that you
         * want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching
         * web requests, and parameters that govern how WAF handles them.
         */
        var rules: List<Rule>? = null
        /**
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         */
        var scope: aws.sdk.kotlin.services.wafv2.model.Scope? = null
        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         */
        var visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.UpdateWebAclRequest) : this() {
            this.customResponseBodies = x.customResponseBodies
            this.defaultAction = x.defaultAction
            this.description = x.description
            this.id = x.id
            this.lockToken = x.lockToken
            this.name = x.name
            this.rules = x.rules
            this.scope = x.scope
            this.visibilityConfig = x.visibilityConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.UpdateWebAclRequest = UpdateWebAclRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.DefaultAction] inside the given [block]
         */
        fun defaultAction(block: aws.sdk.kotlin.services.wafv2.model.DefaultAction.Builder.() -> kotlin.Unit) {
            this.defaultAction = aws.sdk.kotlin.services.wafv2.model.DefaultAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.VisibilityConfig] inside the given [block]
         */
        fun visibilityConfig(block: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.Builder.() -> kotlin.Unit) {
            this.visibilityConfig = aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.invoke(block)
        }
    }
}
