// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Defines and enables Amazon CloudWatch metrics and web request sample collection.
 */
class VisibilityConfig private constructor(builder: Builder) {
    /**
     * A boolean indicating whether the associated resource sends metrics to Amazon CloudWatch. For the
     * list of available metrics, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">WAF
     * Metrics.
     */
    val cloudWatchMetricsEnabled: kotlin.Boolean = builder.cloudWatchMetricsEnabled
    /**
     * A name of the Amazon CloudWatch metric. The name can contain only the characters: A-Z, a-z, 0-9,
     * - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't
     * contain whitespace or metric names reserved for WAF, for example "All" and
     * "Default_Action."
     */
    val metricName: kotlin.String? = builder.metricName
    /**
     * A boolean indicating whether WAF should store a sampling of the web requests that
     * match the rules. You can view the sampled requests through the WAF console.
     */
    val sampledRequestsEnabled: kotlin.Boolean = builder.sampledRequestsEnabled

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.VisibilityConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VisibilityConfig(")
        append("cloudWatchMetricsEnabled=$cloudWatchMetricsEnabled,")
        append("metricName=$metricName,")
        append("sampledRequestsEnabled=$sampledRequestsEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchMetricsEnabled.hashCode()
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (sampledRequestsEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VisibilityConfig

        if (cloudWatchMetricsEnabled != other.cloudWatchMetricsEnabled) return false
        if (metricName != other.metricName) return false
        if (sampledRequestsEnabled != other.sampledRequestsEnabled) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.VisibilityConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * A boolean indicating whether the associated resource sends metrics to Amazon CloudWatch. For the
         * list of available metrics, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">WAF
         * Metrics.
         */
        var cloudWatchMetricsEnabled: kotlin.Boolean = false
        /**
         * A name of the Amazon CloudWatch metric. The name can contain only the characters: A-Z, a-z, 0-9,
         * - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't
         * contain whitespace or metric names reserved for WAF, for example "All" and
         * "Default_Action."
         */
        var metricName: kotlin.String? = null
        /**
         * A boolean indicating whether WAF should store a sampling of the web requests that
         * match the rules. You can view the sampled requests through the WAF console.
         */
        var sampledRequestsEnabled: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig) : this() {
            this.cloudWatchMetricsEnabled = x.cloudWatchMetricsEnabled
            this.metricName = x.metricName
            this.sampledRequestsEnabled = x.sampledRequestsEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.VisibilityConfig = VisibilityConfig(this)
    }
}
