// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wafv2.model.CheckCapacityResponse
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CheckCapacityOperationDeserializer: HttpDeserialize<CheckCapacityResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CheckCapacityResponse {
        if (!response.status.isSuccess()) {
            throwCheckCapacityError(context, response)
        }
        val builder = CheckCapacityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCheckCapacityOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeCheckCapacityOperationBody(builder: CheckCapacityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("Capacity"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPACITY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPACITY_DESCRIPTOR.index -> builder.capacity = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCheckCapacityError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "WAFExpiredManagedRuleGroupVersionException" -> WafExpiredManagedRuleGroupVersionExceptionDeserializer()
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer()
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer()
        "WAFInvalidResourceException" -> WafInvalidResourceExceptionDeserializer()
        "WAFLimitsExceededException" -> WafLimitsExceededExceptionDeserializer()
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer()
        "WAFSubscriptionNotFoundException" -> WafSubscriptionNotFoundExceptionDeserializer()
        "WAFUnavailableEntityException" -> WafUnavailableEntityExceptionDeserializer()
        else -> throw Wafv2Exception(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
