// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wafv2.model.DescribeManagedRuleGroupResponse
import aws.sdk.kotlin.services.wafv2.model.LabelSummary
import aws.sdk.kotlin.services.wafv2.model.RuleSummary
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeManagedRuleGroupOperationDeserializer: HttpDeserialize<DescribeManagedRuleGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeManagedRuleGroupResponse {
        if (!response.status.isSuccess()) {
            throwDescribeManagedRuleGroupError(context, response)
        }
        val builder = DescribeManagedRuleGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeManagedRuleGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeManagedRuleGroupOperationBody(builder: DescribeManagedRuleGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AVAILABLELABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AvailableLabels"))
    val CAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("Capacity"))
    val CONSUMEDLABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ConsumedLabels"))
    val LABELNAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LabelNamespace"))
    val RULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Rules"))
    val SNSTOPICARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SnsTopicArn"))
    val VERSIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AVAILABLELABELS_DESCRIPTOR)
        field(CAPACITY_DESCRIPTOR)
        field(CONSUMEDLABELS_DESCRIPTOR)
        field(LABELNAMESPACE_DESCRIPTOR)
        field(RULES_DESCRIPTOR)
        field(SNSTOPICARN_DESCRIPTOR)
        field(VERSIONNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AVAILABLELABELS_DESCRIPTOR.index -> builder.availableLabels =
                    deserializer.deserializeList(AVAILABLELABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<LabelSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLabelSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CAPACITY_DESCRIPTOR.index -> builder.capacity = deserializeLong()
                CONSUMEDLABELS_DESCRIPTOR.index -> builder.consumedLabels =
                    deserializer.deserializeList(CONSUMEDLABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<LabelSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLabelSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LABELNAMESPACE_DESCRIPTOR.index -> builder.labelNamespace = deserializeString()
                RULES_DESCRIPTOR.index -> builder.rules =
                    deserializer.deserializeList(RULES_DESCRIPTOR) {
                        val col0 = mutableListOf<RuleSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRuleSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SNSTOPICARN_DESCRIPTOR.index -> builder.snsTopicArn = deserializeString()
                VERSIONNAME_DESCRIPTOR.index -> builder.versionName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeManagedRuleGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "WAFExpiredManagedRuleGroupVersionException" -> WafExpiredManagedRuleGroupVersionExceptionDeserializer()
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer()
        "WAFInvalidOperationException" -> WafInvalidOperationExceptionDeserializer()
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer()
        "WAFInvalidResourceException" -> WafInvalidResourceExceptionDeserializer()
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer()
        else -> throw Wafv2Exception(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
