// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wafv2.model.GetRateBasedStatementManagedKeysResponse
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRateBasedStatementManagedKeysOperationDeserializer: HttpDeserialize<GetRateBasedStatementManagedKeysResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRateBasedStatementManagedKeysResponse {
        if (!response.status.isSuccess()) {
            throwGetRateBasedStatementManagedKeysError(context, response)
        }
        val builder = GetRateBasedStatementManagedKeysResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRateBasedStatementManagedKeysOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeGetRateBasedStatementManagedKeysOperationBody(builder: GetRateBasedStatementManagedKeysResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MANAGEDKEYSIPV4_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ManagedKeysIPV4"))
    val MANAGEDKEYSIPV6_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ManagedKeysIPV6"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MANAGEDKEYSIPV4_DESCRIPTOR)
        field(MANAGEDKEYSIPV6_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MANAGEDKEYSIPV4_DESCRIPTOR.index -> builder.managedKeysIpv4 = deserializeRateBasedStatementManagedKeysIpSetDocument(deserializer)
                MANAGEDKEYSIPV6_DESCRIPTOR.index -> builder.managedKeysIpv6 = deserializeRateBasedStatementManagedKeysIpSetDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetRateBasedStatementManagedKeysError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer()
        "WAFInvalidOperationException" -> WafInvalidOperationExceptionDeserializer()
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer()
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer()
        else -> throw Wafv2Exception(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
