// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wafv2.model.GetWebAclResponse
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetWebACLOperationDeserializer: HttpDeserialize<GetWebAclResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetWebAclResponse {
        if (!response.status.isSuccess()) {
            throwGetWebAclError(context, response)
        }
        val builder = GetWebAclResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetWebACLOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeGetWebACLOperationBody(builder: GetWebAclResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LOCKTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LockToken"))
    val WEBACL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("WebACL"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LOCKTOKEN_DESCRIPTOR)
        field(WEBACL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LOCKTOKEN_DESCRIPTOR.index -> builder.lockToken = deserializeString()
                WEBACL_DESCRIPTOR.index -> builder.webAcl = deserializeWebAclDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetWebAclError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer()
        "WAFInvalidOperationException" -> WafInvalidOperationExceptionDeserializer()
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer()
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer()
        else -> throw Wafv2Exception(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
