// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wafv2.model.ListWebAcLsResponse
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.sdk.kotlin.services.wafv2.model.WebAclSummary
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListWebACLsOperationDeserializer: HttpDeserialize<ListWebAcLsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListWebAcLsResponse {
        if (!response.status.isSuccess()) {
            throwListWebAcLsError(context, response)
        }
        val builder = ListWebAcLsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListWebACLsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeListWebACLsOperationBody(builder: ListWebAcLsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTMARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextMarker"))
    val WEBACLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WebACLs"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTMARKER_DESCRIPTOR)
        field(WEBACLS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTMARKER_DESCRIPTOR.index -> builder.nextMarker = deserializeString()
                WEBACLS_DESCRIPTOR.index -> builder.webAcLs =
                    deserializer.deserializeList(WEBACLS_DESCRIPTOR) {
                        val col0 = mutableListOf<WebAclSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWebAclSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwListWebAcLsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer()
        "WAFInvalidOperationException" -> WafInvalidOperationExceptionDeserializer()
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer()
        else -> throw Wafv2Exception(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
