// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateManagedRuleSetVersionExpiryDateOperationDeserializer: HttpDeserialize<UpdateManagedRuleSetVersionExpiryDateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateManagedRuleSetVersionExpiryDateResponse {
        if (!response.status.isSuccess()) {
            throwUpdateManagedRuleSetVersionExpiryDateError(context, response)
        }
        val builder = UpdateManagedRuleSetVersionExpiryDateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateManagedRuleSetVersionExpiryDateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeUpdateManagedRuleSetVersionExpiryDateOperationBody(builder: UpdateManagedRuleSetVersionExpiryDateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXPIRINGVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExpiringVersion"))
    val EXPIRYTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ExpiryTimestamp"))
    val NEXTLOCKTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextLockToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXPIRINGVERSION_DESCRIPTOR)
        field(EXPIRYTIMESTAMP_DESCRIPTOR)
        field(NEXTLOCKTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXPIRINGVERSION_DESCRIPTOR.index -> builder.expiringVersion = deserializeString()
                EXPIRYTIMESTAMP_DESCRIPTOR.index -> builder.expiryTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                NEXTLOCKTOKEN_DESCRIPTOR.index -> builder.nextLockToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwUpdateManagedRuleSetVersionExpiryDateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer()
        "WAFInvalidOperationException" -> WafInvalidOperationExceptionDeserializer()
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer()
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer()
        "WAFOptimisticLockException" -> WafOptimisticLockExceptionDeserializer()
        else -> throw Wafv2Exception(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
