// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.wellarchitected.model.*
import aws.sdk.kotlin.services.wellarchitected.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "WellArchitected"
public const val ServiceApiVersion: String = "2020-03-31"
public const val SdkVersion: String = "0.17.1-beta"

internal class DefaultWellArchitectedClient(override val config: WellArchitectedClient.Config) : WellArchitectedClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associate a lens to a workload.
     *
     * Up to 10 lenses can be associated with a workload in a single API operation. A maximum of 20 lenses can be associated with a workload.
     *
     * **Disclaimer**
     *
     * By accessing and/or applying custom lenses created by another Amazon Web Services user or account, you acknowledge that custom lenses created by other users and shared with you are Third Party Content as defined in the Amazon Web Services Customer Agreement.
     */
    override suspend fun associateLenses(input: AssociateLensesRequest): AssociateLensesResponse {
        val op = SdkHttpOperation.build<AssociateLensesRequest, AssociateLensesResponse> {
            serializer = AssociateLensesOperationSerializer()
            deserializer = AssociateLensesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateLenses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a lens share.
     *
     * The owner of a lens can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Shared access to a lens is not removed until the lens invitation is deleted.
     *
     * **Disclaimer**
     *
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
     */
    override suspend fun createLensShare(input: CreateLensShareRequest): CreateLensShareResponse {
        val op = SdkHttpOperation.build<CreateLensShareRequest, CreateLensShareResponse> {
            serializer = CreateLensShareOperationSerializer()
            deserializer = CreateLensShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLensShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new lens version.
     *
     * A lens can have up to 100 versions.
     *
     * After a lens has been imported, create a new lens version to publish it. The owner of a lens can share the lens with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Only the owner of a lens can delete it.
     */
    override suspend fun createLensVersion(input: CreateLensVersionRequest): CreateLensVersionResponse {
        val op = SdkHttpOperation.build<CreateLensVersionRequest, CreateLensVersionResponse> {
            serializer = CreateLensVersionOperationSerializer()
            deserializer = CreateLensVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLensVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a milestone for an existing workload.
     */
    override suspend fun createMilestone(input: CreateMilestoneRequest): CreateMilestoneResponse {
        val op = SdkHttpOperation.build<CreateMilestoneRequest, CreateMilestoneResponse> {
            serializer = CreateMilestoneOperationSerializer()
            deserializer = CreateMilestoneOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMilestone"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new workload.
     *
     * The owner of a workload can share the workload with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Only the owner of a workload can delete it.
     *
     * For more information, see [Defining a Workload](https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html) in the *Well-Architected Tool User Guide*.
     */
    override suspend fun createWorkload(input: CreateWorkloadRequest): CreateWorkloadResponse {
        val op = SdkHttpOperation.build<CreateWorkloadRequest, CreateWorkloadResponse> {
            serializer = CreateWorkloadOperationSerializer()
            deserializer = CreateWorkloadOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorkload"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a workload share.
     *
     * The owner of a workload can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Shared access to a workload is not removed until the workload invitation is deleted.
     *
     * For more information, see [Sharing a Workload](https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html) in the *Well-Architected Tool User Guide*.
     */
    override suspend fun createWorkloadShare(input: CreateWorkloadShareRequest): CreateWorkloadShareResponse {
        val op = SdkHttpOperation.build<CreateWorkloadShareRequest, CreateWorkloadShareResponse> {
            serializer = CreateWorkloadShareOperationSerializer()
            deserializer = CreateWorkloadShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorkloadShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete an existing lens.
     *
     * Only the owner of a lens can delete it. After the lens is deleted, Amazon Web Services accounts and IAM users that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.
     *
     * **Disclaimer**
     *
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
     */
    override suspend fun deleteLens(input: DeleteLensRequest): DeleteLensResponse {
        val op = SdkHttpOperation.build<DeleteLensRequest, DeleteLensResponse> {
            serializer = DeleteLensOperationSerializer()
            deserializer = DeleteLensOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLens"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete a lens share.
     *
     * After the lens share is deleted, Amazon Web Services accounts and IAM users that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.
     *
     * **Disclaimer**
     *
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.
     */
    override suspend fun deleteLensShare(input: DeleteLensShareRequest): DeleteLensShareResponse {
        val op = SdkHttpOperation.build<DeleteLensShareRequest, DeleteLensShareResponse> {
            serializer = DeleteLensShareOperationSerializer()
            deserializer = DeleteLensShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLensShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete an existing workload.
     */
    override suspend fun deleteWorkload(input: DeleteWorkloadRequest): DeleteWorkloadResponse {
        val op = SdkHttpOperation.build<DeleteWorkloadRequest, DeleteWorkloadResponse> {
            serializer = DeleteWorkloadOperationSerializer()
            deserializer = DeleteWorkloadOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteWorkload"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete a workload share.
     */
    override suspend fun deleteWorkloadShare(input: DeleteWorkloadShareRequest): DeleteWorkloadShareResponse {
        val op = SdkHttpOperation.build<DeleteWorkloadShareRequest, DeleteWorkloadShareResponse> {
            serializer = DeleteWorkloadShareOperationSerializer()
            deserializer = DeleteWorkloadShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteWorkloadShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociate a lens from a workload.
     *
     * Up to 10 lenses can be disassociated from a workload in a single API operation.
     *
     * The Amazon Web Services Well-Architected Framework lens (`wellarchitected`) cannot be removed from a workload.
     */
    override suspend fun disassociateLenses(input: DisassociateLensesRequest): DisassociateLensesResponse {
        val op = SdkHttpOperation.build<DisassociateLensesRequest, DisassociateLensesResponse> {
            serializer = DisassociateLensesOperationSerializer()
            deserializer = DisassociateLensesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateLenses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Export an existing lens.
     *
     * Lenses are defined in JSON. For more information, see [JSON format specification](https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html) in the *Well-Architected Tool User Guide*. Only the owner of a lens can export it.
     *
     * **Disclaimer**
     *
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     */
    override suspend fun exportLens(input: ExportLensRequest): ExportLensResponse {
        val op = SdkHttpOperation.build<ExportLensRequest, ExportLensResponse> {
            serializer = ExportLensOperationSerializer()
            deserializer = ExportLensOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportLens"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get the answer to a specific question in a workload review.
     */
    override suspend fun getAnswer(input: GetAnswerRequest): GetAnswerResponse {
        val op = SdkHttpOperation.build<GetAnswerRequest, GetAnswerResponse> {
            serializer = GetAnswerOperationSerializer()
            deserializer = GetAnswerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAnswer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get an existing lens.
     */
    override suspend fun getLens(input: GetLensRequest): GetLensResponse {
        val op = SdkHttpOperation.build<GetLensRequest, GetLensResponse> {
            serializer = GetLensOperationSerializer()
            deserializer = GetLensOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLens"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get lens review.
     */
    override suspend fun getLensReview(input: GetLensReviewRequest): GetLensReviewResponse {
        val op = SdkHttpOperation.build<GetLensReviewRequest, GetLensReviewResponse> {
            serializer = GetLensReviewOperationSerializer()
            deserializer = GetLensReviewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLensReview"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get lens review report.
     */
    override suspend fun getLensReviewReport(input: GetLensReviewReportRequest): GetLensReviewReportResponse {
        val op = SdkHttpOperation.build<GetLensReviewReportRequest, GetLensReviewReportResponse> {
            serializer = GetLensReviewReportOperationSerializer()
            deserializer = GetLensReviewReportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLensReviewReport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get lens version differences.
     */
    override suspend fun getLensVersionDifference(input: GetLensVersionDifferenceRequest): GetLensVersionDifferenceResponse {
        val op = SdkHttpOperation.build<GetLensVersionDifferenceRequest, GetLensVersionDifferenceResponse> {
            serializer = GetLensVersionDifferenceOperationSerializer()
            deserializer = GetLensVersionDifferenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLensVersionDifference"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get a milestone for an existing workload.
     */
    override suspend fun getMilestone(input: GetMilestoneRequest): GetMilestoneResponse {
        val op = SdkHttpOperation.build<GetMilestoneRequest, GetMilestoneResponse> {
            serializer = GetMilestoneOperationSerializer()
            deserializer = GetMilestoneOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMilestone"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get an existing workload.
     */
    override suspend fun getWorkload(input: GetWorkloadRequest): GetWorkloadResponse {
        val op = SdkHttpOperation.build<GetWorkloadRequest, GetWorkloadResponse> {
            serializer = GetWorkloadOperationSerializer()
            deserializer = GetWorkloadOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWorkload"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Import a new lens.
     *
     * The lens cannot be applied to workloads or shared with other Amazon Web Services accounts until it's published with CreateLensVersion
     *
     * Lenses are defined in JSON. For more information, see [JSON format specification](https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html) in the *Well-Architected Tool User Guide*.
     *
     * A custom lens cannot exceed 500 KB in size.
     *
     * **Disclaimer**
     *
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     */
    override suspend fun importLens(input: ImportLensRequest): ImportLensResponse {
        val op = SdkHttpOperation.build<ImportLensRequest, ImportLensResponse> {
            serializer = ImportLensOperationSerializer()
            deserializer = ImportLensOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportLens"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List of answers.
     */
    override suspend fun listAnswers(input: ListAnswersRequest): ListAnswersResponse {
        val op = SdkHttpOperation.build<ListAnswersRequest, ListAnswersResponse> {
            serializer = ListAnswersOperationSerializer()
            deserializer = ListAnswersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAnswers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List lens review improvements.
     */
    override suspend fun listLensReviewImprovements(input: ListLensReviewImprovementsRequest): ListLensReviewImprovementsResponse {
        val op = SdkHttpOperation.build<ListLensReviewImprovementsRequest, ListLensReviewImprovementsResponse> {
            serializer = ListLensReviewImprovementsOperationSerializer()
            deserializer = ListLensReviewImprovementsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLensReviewImprovements"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List lens reviews.
     */
    override suspend fun listLensReviews(input: ListLensReviewsRequest): ListLensReviewsResponse {
        val op = SdkHttpOperation.build<ListLensReviewsRequest, ListLensReviewsResponse> {
            serializer = ListLensReviewsOperationSerializer()
            deserializer = ListLensReviewsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLensReviews"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the lens shares associated with the lens.
     */
    override suspend fun listLensShares(input: ListLensSharesRequest): ListLensSharesResponse {
        val op = SdkHttpOperation.build<ListLensSharesRequest, ListLensSharesResponse> {
            serializer = ListLensSharesOperationSerializer()
            deserializer = ListLensSharesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLensShares"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the available lenses.
     */
    override suspend fun listLenses(input: ListLensesRequest): ListLensesResponse {
        val op = SdkHttpOperation.build<ListLensesRequest, ListLensesResponse> {
            serializer = ListLensesOperationSerializer()
            deserializer = ListLensesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLenses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all milestones for an existing workload.
     */
    override suspend fun listMilestones(input: ListMilestonesRequest): ListMilestonesResponse {
        val op = SdkHttpOperation.build<ListMilestonesRequest, ListMilestonesResponse> {
            serializer = ListMilestonesOperationSerializer()
            deserializer = ListMilestonesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMilestones"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List lens notifications.
     */
    override suspend fun listNotifications(input: ListNotificationsRequest): ListNotificationsResponse {
        val op = SdkHttpOperation.build<ListNotificationsRequest, ListNotificationsResponse> {
            serializer = ListNotificationsOperationSerializer()
            deserializer = ListNotificationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNotifications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the workload invitations.
     */
    override suspend fun listShareInvitations(input: ListShareInvitationsRequest): ListShareInvitationsResponse {
        val op = SdkHttpOperation.build<ListShareInvitationsRequest, ListShareInvitationsResponse> {
            serializer = ListShareInvitationsOperationSerializer()
            deserializer = ListShareInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListShareInvitations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the tags for a resource.
     *
     * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the workload shares associated with the workload.
     */
    override suspend fun listWorkloadShares(input: ListWorkloadSharesRequest): ListWorkloadSharesResponse {
        val op = SdkHttpOperation.build<ListWorkloadSharesRequest, ListWorkloadSharesResponse> {
            serializer = ListWorkloadSharesOperationSerializer()
            deserializer = ListWorkloadSharesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorkloadShares"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List workloads. Paginated.
     */
    override suspend fun listWorkloads(input: ListWorkloadsRequest): ListWorkloadsResponse {
        val op = SdkHttpOperation.build<ListWorkloadsRequest, ListWorkloadsResponse> {
            serializer = ListWorkloadsOperationSerializer()
            deserializer = ListWorkloadsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorkloads"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more tags to the specified resource.
     *
     * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes specified tags from a resource.
     *
     * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
     *
     * To specify multiple tags, use separate **tagKeys** parameters, for example:
     *
     * `DELETE /tags/WorkloadArn?tagKeys=key1&tagKeys=key2`
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update the answer to a specific question in a workload review.
     */
    override suspend fun updateAnswer(input: UpdateAnswerRequest): UpdateAnswerResponse {
        val op = SdkHttpOperation.build<UpdateAnswerRequest, UpdateAnswerResponse> {
            serializer = UpdateAnswerOperationSerializer()
            deserializer = UpdateAnswerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAnswer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates whether the Amazon Web Services account is opted into organization sharing features.
     */
    override suspend fun updateGlobalSettings(input: UpdateGlobalSettingsRequest): UpdateGlobalSettingsResponse {
        val op = SdkHttpOperation.build<UpdateGlobalSettingsRequest, UpdateGlobalSettingsResponse> {
            serializer = UpdateGlobalSettingsOperationSerializer()
            deserializer = UpdateGlobalSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGlobalSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update lens review.
     */
    override suspend fun updateLensReview(input: UpdateLensReviewRequest): UpdateLensReviewResponse {
        val op = SdkHttpOperation.build<UpdateLensReviewRequest, UpdateLensReviewResponse> {
            serializer = UpdateLensReviewOperationSerializer()
            deserializer = UpdateLensReviewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLensReview"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a workload invitation.
     */
    override suspend fun updateShareInvitation(input: UpdateShareInvitationRequest): UpdateShareInvitationResponse {
        val op = SdkHttpOperation.build<UpdateShareInvitationRequest, UpdateShareInvitationResponse> {
            serializer = UpdateShareInvitationOperationSerializer()
            deserializer = UpdateShareInvitationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateShareInvitation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update an existing workload.
     */
    override suspend fun updateWorkload(input: UpdateWorkloadRequest): UpdateWorkloadResponse {
        val op = SdkHttpOperation.build<UpdateWorkloadRequest, UpdateWorkloadResponse> {
            serializer = UpdateWorkloadOperationSerializer()
            deserializer = UpdateWorkloadOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateWorkload"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a workload share.
     */
    override suspend fun updateWorkloadShare(input: UpdateWorkloadShareRequest): UpdateWorkloadShareResponse {
        val op = SdkHttpOperation.build<UpdateWorkloadShareRequest, UpdateWorkloadShareResponse> {
            serializer = UpdateWorkloadShareOperationSerializer()
            deserializer = UpdateWorkloadShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateWorkloadShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Upgrade lens review.
     */
    override suspend fun upgradeLensReview(input: UpgradeLensReviewRequest): UpgradeLensReviewResponse {
        val op = SdkHttpOperation.build<UpgradeLensReviewRequest, UpgradeLensReviewResponse> {
            serializer = UpgradeLensReviewOperationSerializer()
            deserializer = UpgradeLensReviewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpgradeLensReview"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "wellarchitected"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "wellarchitected")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
