// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model



public class CreateLensVersionRequest private constructor(builder: Builder) {
    /**
     * A unique case-sensitive string used to ensure that this request is idempotent (executes only once).
     *
     * You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned.
     *
     * This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Set to true if this new major lens version.
     */
    public val isMajorVersion: kotlin.Boolean = builder.isMajorVersion
    /**
     * The alias of the lens.
     *
     * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-west-2::lens/serverless`.
     *
     * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens`.
     *
     * Each lens is identified by its LensSummary$LensAlias.
     */
    public val lensAlias: kotlin.String? = requireNotNull(builder.lensAlias) { "A non-null value must be provided for lensAlias" }
    /**
     * The version of the lens being created.
     */
    public val lensVersion: kotlin.String? = builder.lensVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.CreateLensVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLensVersionRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("isMajorVersion=$isMajorVersion,")
        append("lensAlias=$lensAlias,")
        append("lensVersion=$lensVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (isMajorVersion.hashCode())
        result = 31 * result + (lensAlias?.hashCode() ?: 0)
        result = 31 * result + (lensVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLensVersionRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (isMajorVersion != other.isMajorVersion) return false
        if (lensAlias != other.lensAlias) return false
        if (lensVersion != other.lensVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.CreateLensVersionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique case-sensitive string used to ensure that this request is idempotent (executes only once).
         *
         * You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned.
         *
         * This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Set to true if this new major lens version.
         */
        public var isMajorVersion: kotlin.Boolean = false
        /**
         * The alias of the lens.
         *
         * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-west-2::lens/serverless`.
         *
         * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens`.
         *
         * Each lens is identified by its LensSummary$LensAlias.
         */
        public var lensAlias: kotlin.String? = null
        /**
         * The version of the lens being created.
         */
        public var lensVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.CreateLensVersionRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.isMajorVersion = x.isMajorVersion
            this.lensAlias = x.lensAlias
            this.lensVersion = x.lensVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.CreateLensVersionRequest = CreateLensVersionRequest(this)
    }
}
