// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model



/**
 * Lens upgrade summary return object.
 */
public class LensUpgradeSummary private constructor(builder: Builder) {
    /**
     * The current version of the lens.
     */
    public val currentLensVersion: kotlin.String? = builder.currentLensVersion
    /**
     * The latest version of the lens.
     */
    public val latestLensVersion: kotlin.String? = builder.latestLensVersion
    /**
     * The alias of the lens.
     *
     * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-west-2::lens/serverless`.
     *
     * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens`.
     *
     * Each lens is identified by its LensSummary$LensAlias.
     */
    public val lensAlias: kotlin.String? = builder.lensAlias
    /**
     * The ARN for the lens.
     */
    public val lensArn: kotlin.String? = builder.lensArn
    /**
     * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
     */
    public val workloadId: kotlin.String? = builder.workloadId
    /**
     * The name of the workload.
     *
     * The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.
     */
    public val workloadName: kotlin.String? = builder.workloadName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.LensUpgradeSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LensUpgradeSummary(")
        append("currentLensVersion=$currentLensVersion,")
        append("latestLensVersion=$latestLensVersion,")
        append("lensAlias=$lensAlias,")
        append("lensArn=$lensArn,")
        append("workloadId=$workloadId,")
        append("workloadName=$workloadName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentLensVersion?.hashCode() ?: 0
        result = 31 * result + (latestLensVersion?.hashCode() ?: 0)
        result = 31 * result + (lensAlias?.hashCode() ?: 0)
        result = 31 * result + (lensArn?.hashCode() ?: 0)
        result = 31 * result + (workloadId?.hashCode() ?: 0)
        result = 31 * result + (workloadName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LensUpgradeSummary

        if (currentLensVersion != other.currentLensVersion) return false
        if (latestLensVersion != other.latestLensVersion) return false
        if (lensAlias != other.lensAlias) return false
        if (lensArn != other.lensArn) return false
        if (workloadId != other.workloadId) return false
        if (workloadName != other.workloadName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.LensUpgradeSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The current version of the lens.
         */
        public var currentLensVersion: kotlin.String? = null
        /**
         * The latest version of the lens.
         */
        public var latestLensVersion: kotlin.String? = null
        /**
         * The alias of the lens.
         *
         * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-west-2::lens/serverless`.
         *
         * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens`.
         *
         * Each lens is identified by its LensSummary$LensAlias.
         */
        public var lensAlias: kotlin.String? = null
        /**
         * The ARN for the lens.
         */
        public var lensArn: kotlin.String? = null
        /**
         * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
         */
        public var workloadId: kotlin.String? = null
        /**
         * The name of the workload.
         *
         * The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.
         */
        public var workloadName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.LensUpgradeSummary) : this() {
            this.currentLensVersion = x.currentLensVersion
            this.latestLensVersion = x.latestLensVersion
            this.lensAlias = x.lensAlias
            this.lensArn = x.lensArn
            this.workloadId = x.workloadId
            this.workloadName = x.workloadName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.LensUpgradeSummary = LensUpgradeSummary(this)
    }
}
