// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model



/**
 * Input to list lens review improvements.
 */
public class ListLensReviewImprovementsRequest private constructor(builder: Builder) {
    /**
     * The alias of the lens.
     *
     * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-west-2::lens/serverless`.
     *
     * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens`.
     *
     * Each lens is identified by its LensSummary$LensAlias.
     */
    public val lensAlias: kotlin.String? = requireNotNull(builder.lensAlias) { "A non-null value must be provided for lensAlias" }
    /**
     * The maximum number of results to return for this request.
     */
    public val maxResults: kotlin.Int = builder.maxResults
    /**
     * The milestone number.
     *
     * A workload can have a maximum of 100 milestones.
     */
    public val milestoneNumber: kotlin.Int = builder.milestoneNumber
    /**
     * The token to use to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ID used to identify a pillar, for example, `security`.
     *
     * A pillar is identified by its PillarReviewSummary$PillarId.
     */
    public val pillarId: kotlin.String? = builder.pillarId
    /**
     * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
     */
    public val workloadId: kotlin.String? = requireNotNull(builder.workloadId) { "A non-null value must be provided for workloadId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewImprovementsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListLensReviewImprovementsRequest(")
        append("lensAlias=$lensAlias,")
        append("maxResults=$maxResults,")
        append("milestoneNumber=$milestoneNumber,")
        append("nextToken=$nextToken,")
        append("pillarId=$pillarId,")
        append("workloadId=$workloadId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lensAlias?.hashCode() ?: 0
        result = 31 * result + (maxResults)
        result = 31 * result + (milestoneNumber)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (pillarId?.hashCode() ?: 0)
        result = 31 * result + (workloadId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListLensReviewImprovementsRequest

        if (lensAlias != other.lensAlias) return false
        if (maxResults != other.maxResults) return false
        if (milestoneNumber != other.milestoneNumber) return false
        if (nextToken != other.nextToken) return false
        if (pillarId != other.pillarId) return false
        if (workloadId != other.workloadId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewImprovementsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The alias of the lens.
         *
         * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-west-2::lens/serverless`.
         *
         * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens`.
         *
         * Each lens is identified by its LensSummary$LensAlias.
         */
        public var lensAlias: kotlin.String? = null
        /**
         * The maximum number of results to return for this request.
         */
        public var maxResults: kotlin.Int = 0
        /**
         * The milestone number.
         *
         * A workload can have a maximum of 100 milestones.
         */
        public var milestoneNumber: kotlin.Int = 0
        /**
         * The token to use to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ID used to identify a pillar, for example, `security`.
         *
         * A pillar is identified by its PillarReviewSummary$PillarId.
         */
        public var pillarId: kotlin.String? = null
        /**
         * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
         */
        public var workloadId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewImprovementsRequest) : this() {
            this.lensAlias = x.lensAlias
            this.maxResults = x.maxResults
            this.milestoneNumber = x.milestoneNumber
            this.nextToken = x.nextToken
            this.pillarId = x.pillarId
            this.workloadId = x.workloadId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.ListLensReviewImprovementsRequest = ListLensReviewImprovementsRequest(this)
    }
}
