// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model



/**
 * Input to update a workload.
 */
public class UpdateWorkloadRequest private constructor(builder: Builder) {
    /**
     * The list of Amazon Web Services account IDs associated with the workload.
     */
    public val accountIds: List<String>? = builder.accountIds
    /**
     * The URL of the architectural design for the workload.
     */
    public val architecturalDesign: kotlin.String? = builder.architecturalDesign
    /**
     * The list of Amazon Web Services Regions associated with the workload, for example, `us-east-2`, or `ca-central-1`.
     */
    public val awsRegions: List<String>? = builder.awsRegions
    /**
     * The description for the workload.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The environment for the workload.
     */
    public val environment: aws.sdk.kotlin.services.wellarchitected.model.WorkloadEnvironment? = builder.environment
    /**
     * The improvement status for a workload.
     */
    public val improvementStatus: aws.sdk.kotlin.services.wellarchitected.model.WorkloadImprovementStatus? = builder.improvementStatus
    /**
     * The industry for the workload.
     */
    public val industry: kotlin.String? = builder.industry
    /**
     * The industry type for the workload.
     *
     * If specified, must be one of the following:
     * + `Agriculture`
     * + `Automobile`
     * + `Defense`
     * + `Design and Engineering`
     * + `Digital Advertising`
     * + `Education`
     * + `Environmental Protection`
     * + `Financial Services`
     * + `Gaming`
     * + `General Public Services`
     * + `Healthcare`
     * + `Hospitality`
     * + `InfoTech`
     * + `Justice and Public Safety`
     * + `Life Sciences`
     * + `Manufacturing`
     * + `Media & Entertainment`
     * + `Mining & Resources`
     * + `Oil & Gas`
     * + `Power & Utilities`
     * + `Professional Services`
     * + `Real Estate & Construction`
     * + `Retail & Wholesale`
     * + `Social Protection`
     * + `Telecommunications`
     * + `Travel, Transportation & Logistics`
     * + `Other`
     */
    public val industryType: kotlin.String? = builder.industryType
    /**
     * Flag indicating whether the workload owner has acknowledged that the *Review owner* field is required.
     *
     * If a **Review owner** is not added to the workload within 60 days of acknowledgement, access to the workload is restricted until an owner is added.
     */
    public val isReviewOwnerUpdateAcknowledged: kotlin.Boolean = builder.isReviewOwnerUpdateAcknowledged
    /**
     * The list of non-Amazon Web Services Regions associated with the workload.
     */
    public val nonAwsRegions: List<String>? = builder.nonAwsRegions
    /**
     * The notes associated with the workload.
     */
    public val notes: kotlin.String? = builder.notes
    /**
     * The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its PillarReviewSummary$PillarId.
     */
    public val pillarPriorities: List<String>? = builder.pillarPriorities
    /**
     * The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.
     */
    public val reviewOwner: kotlin.String? = builder.reviewOwner
    /**
     * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
     */
    public val workloadId: kotlin.String? = requireNotNull(builder.workloadId) { "A non-null value must be provided for workloadId" }
    /**
     * The name of the workload.
     *
     * The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.
     */
    public val workloadName: kotlin.String? = builder.workloadName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.UpdateWorkloadRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateWorkloadRequest(")
        append("accountIds=$accountIds,")
        append("architecturalDesign=$architecturalDesign,")
        append("awsRegions=$awsRegions,")
        append("description=$description,")
        append("environment=$environment,")
        append("improvementStatus=$improvementStatus,")
        append("industry=$industry,")
        append("industryType=$industryType,")
        append("isReviewOwnerUpdateAcknowledged=$isReviewOwnerUpdateAcknowledged,")
        append("nonAwsRegions=$nonAwsRegions,")
        append("notes=$notes,")
        append("pillarPriorities=$pillarPriorities,")
        append("reviewOwner=$reviewOwner,")
        append("workloadId=$workloadId,")
        append("workloadName=$workloadName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (architecturalDesign?.hashCode() ?: 0)
        result = 31 * result + (awsRegions?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (improvementStatus?.hashCode() ?: 0)
        result = 31 * result + (industry?.hashCode() ?: 0)
        result = 31 * result + (industryType?.hashCode() ?: 0)
        result = 31 * result + (isReviewOwnerUpdateAcknowledged.hashCode())
        result = 31 * result + (nonAwsRegions?.hashCode() ?: 0)
        result = 31 * result + (notes?.hashCode() ?: 0)
        result = 31 * result + (pillarPriorities?.hashCode() ?: 0)
        result = 31 * result + (reviewOwner?.hashCode() ?: 0)
        result = 31 * result + (workloadId?.hashCode() ?: 0)
        result = 31 * result + (workloadName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateWorkloadRequest

        if (accountIds != other.accountIds) return false
        if (architecturalDesign != other.architecturalDesign) return false
        if (awsRegions != other.awsRegions) return false
        if (description != other.description) return false
        if (environment != other.environment) return false
        if (improvementStatus != other.improvementStatus) return false
        if (industry != other.industry) return false
        if (industryType != other.industryType) return false
        if (isReviewOwnerUpdateAcknowledged != other.isReviewOwnerUpdateAcknowledged) return false
        if (nonAwsRegions != other.nonAwsRegions) return false
        if (notes != other.notes) return false
        if (pillarPriorities != other.pillarPriorities) return false
        if (reviewOwner != other.reviewOwner) return false
        if (workloadId != other.workloadId) return false
        if (workloadName != other.workloadName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.UpdateWorkloadRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of Amazon Web Services account IDs associated with the workload.
         */
        public var accountIds: List<String>? = null
        /**
         * The URL of the architectural design for the workload.
         */
        public var architecturalDesign: kotlin.String? = null
        /**
         * The list of Amazon Web Services Regions associated with the workload, for example, `us-east-2`, or `ca-central-1`.
         */
        public var awsRegions: List<String>? = null
        /**
         * The description for the workload.
         */
        public var description: kotlin.String? = null
        /**
         * The environment for the workload.
         */
        public var environment: aws.sdk.kotlin.services.wellarchitected.model.WorkloadEnvironment? = null
        /**
         * The improvement status for a workload.
         */
        public var improvementStatus: aws.sdk.kotlin.services.wellarchitected.model.WorkloadImprovementStatus? = null
        /**
         * The industry for the workload.
         */
        public var industry: kotlin.String? = null
        /**
         * The industry type for the workload.
         *
         * If specified, must be one of the following:
         * + `Agriculture`
         * + `Automobile`
         * + `Defense`
         * + `Design and Engineering`
         * + `Digital Advertising`
         * + `Education`
         * + `Environmental Protection`
         * + `Financial Services`
         * + `Gaming`
         * + `General Public Services`
         * + `Healthcare`
         * + `Hospitality`
         * + `InfoTech`
         * + `Justice and Public Safety`
         * + `Life Sciences`
         * + `Manufacturing`
         * + `Media & Entertainment`
         * + `Mining & Resources`
         * + `Oil & Gas`
         * + `Power & Utilities`
         * + `Professional Services`
         * + `Real Estate & Construction`
         * + `Retail & Wholesale`
         * + `Social Protection`
         * + `Telecommunications`
         * + `Travel, Transportation & Logistics`
         * + `Other`
         */
        public var industryType: kotlin.String? = null
        /**
         * Flag indicating whether the workload owner has acknowledged that the *Review owner* field is required.
         *
         * If a **Review owner** is not added to the workload within 60 days of acknowledgement, access to the workload is restricted until an owner is added.
         */
        public var isReviewOwnerUpdateAcknowledged: kotlin.Boolean = false
        /**
         * The list of non-Amazon Web Services Regions associated with the workload.
         */
        public var nonAwsRegions: List<String>? = null
        /**
         * The notes associated with the workload.
         */
        public var notes: kotlin.String? = null
        /**
         * The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its PillarReviewSummary$PillarId.
         */
        public var pillarPriorities: List<String>? = null
        /**
         * The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.
         */
        public var reviewOwner: kotlin.String? = null
        /**
         * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
         */
        public var workloadId: kotlin.String? = null
        /**
         * The name of the workload.
         *
         * The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.
         */
        public var workloadName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.UpdateWorkloadRequest) : this() {
            this.accountIds = x.accountIds
            this.architecturalDesign = x.architecturalDesign
            this.awsRegions = x.awsRegions
            this.description = x.description
            this.environment = x.environment
            this.improvementStatus = x.improvementStatus
            this.industry = x.industry
            this.industryType = x.industryType
            this.isReviewOwnerUpdateAcknowledged = x.isReviewOwnerUpdateAcknowledged
            this.nonAwsRegions = x.nonAwsRegions
            this.notes = x.notes
            this.pillarPriorities = x.pillarPriorities
            this.reviewOwner = x.reviewOwner
            this.workloadId = x.workloadId
            this.workloadName = x.workloadName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.UpdateWorkloadRequest = UpdateWorkloadRequest(this)
    }
}
