// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.model



public class UpgradeLensReviewRequest private constructor(builder: Builder) {
    /**
     * A unique case-sensitive string used to ensure that this request is idempotent (executes only once).
     *
     * You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned.
     *
     * This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The alias of the lens.
     *
     * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-west-2::lens/serverless`.
     *
     * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens`.
     *
     * Each lens is identified by its LensSummary$LensAlias.
     */
    public val lensAlias: kotlin.String? = requireNotNull(builder.lensAlias) { "A non-null value must be provided for lensAlias" }
    /**
     * The name of the milestone in a workload.
     *
     * Milestone names must be unique within a workload.
     */
    public val milestoneName: kotlin.String? = builder.milestoneName
    /**
     * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
     */
    public val workloadId: kotlin.String? = requireNotNull(builder.workloadId) { "A non-null value must be provided for workloadId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wellarchitected.model.UpgradeLensReviewRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpgradeLensReviewRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("lensAlias=$lensAlias,")
        append("milestoneName=$milestoneName,")
        append("workloadId=$workloadId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (lensAlias?.hashCode() ?: 0)
        result = 31 * result + (milestoneName?.hashCode() ?: 0)
        result = 31 * result + (workloadId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpgradeLensReviewRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (lensAlias != other.lensAlias) return false
        if (milestoneName != other.milestoneName) return false
        if (workloadId != other.workloadId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wellarchitected.model.UpgradeLensReviewRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique case-sensitive string used to ensure that this request is idempotent (executes only once).
         *
         * You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned.
         *
         * This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The alias of the lens.
         *
         * For Amazon Web Services official lenses, this is either the lens alias, such as `serverless`, or the lens ARN, such as `arn:aws:wellarchitected:us-west-2::lens/serverless`.
         *
         * For custom lenses, this is the lens ARN, such as `arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens`.
         *
         * Each lens is identified by its LensSummary$LensAlias.
         */
        public var lensAlias: kotlin.String? = null
        /**
         * The name of the milestone in a workload.
         *
         * Milestone names must be unique within a workload.
         */
        public var milestoneName: kotlin.String? = null
        /**
         * The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.
         */
        public var workloadId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wellarchitected.model.UpgradeLensReviewRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.lensAlias = x.lensAlias
            this.milestoneName = x.milestoneName
            this.workloadId = x.workloadId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wellarchitected.model.UpgradeLensReviewRequest = UpgradeLensReviewRequest(this)
    }
}
