// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.transform

import aws.sdk.kotlin.services.wellarchitected.model.UpdateLensReviewRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateLensReviewOperationSerializer: HttpSerialize<UpdateLensReviewRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateLensReviewRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf(
                "workloads",
                "${input.workloadId}".encodeLabel(),
                "lensReviews",
                "${input.lensAlias}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateLensReviewOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateLensReviewOperationBody(context: ExecutionContext, input: UpdateLensReviewRequest): ByteArray {
    val serializer = JsonSerializer()
    val LENSNOTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LensNotes"))
    val PILLARNOTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("PillarNotes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LENSNOTES_DESCRIPTOR)
        field(PILLARNOTES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.lensNotes?.let { field(LENSNOTES_DESCRIPTOR, it) }
        if (input.pillarNotes != null) {
            mapField(PILLARNOTES_DESCRIPTOR) {
                input.pillarNotes.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
