// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wisdom

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.wisdom.model.*
import aws.sdk.kotlin.services.wisdom.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Wisdom"
const val ServiceApiVersion: String = "2020-10-19"
const val SdkVersion: String = "0.13.0-beta"

internal class DefaultWisdomClient(override val config: WisdomClient.Config) : WisdomClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates an Amazon Connect Wisdom assistant.
     */
    override suspend fun createAssistant(input: CreateAssistantRequest): CreateAssistantResponse {
        val op = SdkHttpOperation.build<CreateAssistantRequest, CreateAssistantResponse> {
            serializer = CreateAssistantOperationSerializer()
            deserializer = CreateAssistantOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAssistant"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an association between an Amazon Connect Wisdom assistant and another resource. Currently, the
     * only supported association is with a knowledge base. An assistant can have only a single
     * association.
     */
    override suspend fun createAssistantAssociation(input: CreateAssistantAssociationRequest): CreateAssistantAssociationResponse {
        val op = SdkHttpOperation.build<CreateAssistantAssociationRequest, CreateAssistantAssociationResponse> {
            serializer = CreateAssistantAssociationOperationSerializer()
            deserializer = CreateAssistantAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAssistantAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates Wisdom content. Before to calling this API, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload to
     * upload an asset.
     */
    override suspend fun createContent(input: CreateContentRequest): CreateContentResponse {
        val op = SdkHttpOperation.build<CreateContentRequest, CreateContentResponse> {
            serializer = CreateContentOperationSerializer()
            deserializer = CreateContentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateContent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a knowledge base.
     *
     * When using this API, you cannot reuse <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations
     * DataIntegrations with external knowledge bases such as Salesforce and ServiceNow. If you do,
     * you'll get an InvalidRequestException error.
     *
     * For example, you're programmatically managing your external knowledge base, and you want
     * to add or remove one of the fields that is being ingested from Salesforce. Do the
     * following:
     * <ol>
     *
     * Call <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteKnowledgeBase.html">DeleteKnowledgeBase.
     *
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">DeleteDataIntegration.
     *
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration to recreate the DataIntegration or a create different
     * one.
     *
     * Call CreateKnowledgeBase.
     *
     * </ol>
     */
    override suspend fun createKnowledgeBase(input: CreateKnowledgeBaseRequest): CreateKnowledgeBaseResponse {
        val op = SdkHttpOperation.build<CreateKnowledgeBaseRequest, CreateKnowledgeBaseResponse> {
            serializer = CreateKnowledgeBaseOperationSerializer()
            deserializer = CreateKnowledgeBaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateKnowledgeBase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a session. A session is a contextual container used for generating
     * recommendations. Amazon Connect creates a new Wisdom session for each contact on which Wisdom is
     * enabled.
     */
    override suspend fun createSession(input: CreateSessionRequest): CreateSessionResponse {
        val op = SdkHttpOperation.build<CreateSessionRequest, CreateSessionResponse> {
            serializer = CreateSessionOperationSerializer()
            deserializer = CreateSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an assistant.
     */
    override suspend fun deleteAssistant(input: DeleteAssistantRequest): DeleteAssistantResponse {
        val op = SdkHttpOperation.build<DeleteAssistantRequest, DeleteAssistantResponse> {
            serializer = DeleteAssistantOperationSerializer()
            deserializer = DeleteAssistantOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAssistant"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an assistant association.
     */
    override suspend fun deleteAssistantAssociation(input: DeleteAssistantAssociationRequest): DeleteAssistantAssociationResponse {
        val op = SdkHttpOperation.build<DeleteAssistantAssociationRequest, DeleteAssistantAssociationResponse> {
            serializer = DeleteAssistantAssociationOperationSerializer()
            deserializer = DeleteAssistantAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAssistantAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the content.
     */
    override suspend fun deleteContent(input: DeleteContentRequest): DeleteContentResponse {
        val op = SdkHttpOperation.build<DeleteContentRequest, DeleteContentResponse> {
            serializer = DeleteContentOperationSerializer()
            deserializer = DeleteContentOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteContent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the knowledge base.
     *
     * When you use this API to delete an external knowledge base such as Salesforce or
     * ServiceNow, you must also delete the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations DataIntegration.
     * This is because you can't reuse the DataIntegration after it's been associated with an
     * external knowledge base. However, you can delete and recreate it. See <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">DeleteDataIntegration and <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration in the Amazon AppIntegrations API
     * Reference.
     */
    override suspend fun deleteKnowledgeBase(input: DeleteKnowledgeBaseRequest): DeleteKnowledgeBaseResponse {
        val op = SdkHttpOperation.build<DeleteKnowledgeBaseRequest, DeleteKnowledgeBaseResponse> {
            serializer = DeleteKnowledgeBaseOperationSerializer()
            deserializer = DeleteKnowledgeBaseOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteKnowledgeBase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about an assistant.
     */
    override suspend fun getAssistant(input: GetAssistantRequest): GetAssistantResponse {
        val op = SdkHttpOperation.build<GetAssistantRequest, GetAssistantResponse> {
            serializer = GetAssistantOperationSerializer()
            deserializer = GetAssistantOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssistant"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about an assistant association.
     */
    override suspend fun getAssistantAssociation(input: GetAssistantAssociationRequest): GetAssistantAssociationResponse {
        val op = SdkHttpOperation.build<GetAssistantAssociationRequest, GetAssistantAssociationResponse> {
            serializer = GetAssistantAssociationOperationSerializer()
            deserializer = GetAssistantAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssistantAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves content, including a pre-signed URL to download the content.
     */
    override suspend fun getContent(input: GetContentRequest): GetContentResponse {
        val op = SdkHttpOperation.build<GetContentRequest, GetContentResponse> {
            serializer = GetContentOperationSerializer()
            deserializer = GetContentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves summary information about the content.
     */
    override suspend fun getContentSummary(input: GetContentSummaryRequest): GetContentSummaryResponse {
        val op = SdkHttpOperation.build<GetContentSummaryRequest, GetContentSummaryResponse> {
            serializer = GetContentSummaryOperationSerializer()
            deserializer = GetContentSummaryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContentSummary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the knowledge base.
     */
    override suspend fun getKnowledgeBase(input: GetKnowledgeBaseRequest): GetKnowledgeBaseResponse {
        val op = SdkHttpOperation.build<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse> {
            serializer = GetKnowledgeBaseOperationSerializer()
            deserializer = GetKnowledgeBaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetKnowledgeBase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves recommendations for the specified session. To avoid retrieving the same
     * recommendations in subsequent calls, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_NotifyRecommendationsReceived.html">NotifyRecommendationsReceived. This API supports long-polling behavior with the
     * waitTimeSeconds parameter. Short poll is the default behavior and only returns
     * recommendations already available. To perform a manual query against an assistant, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_QueryAssistant.html">QueryAssistant.
     */
    override suspend fun getRecommendations(input: GetRecommendationsRequest): GetRecommendationsResponse {
        val op = SdkHttpOperation.build<GetRecommendationsRequest, GetRecommendationsResponse> {
            serializer = GetRecommendationsOperationSerializer()
            deserializer = GetRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information for a specified session.
     */
    override suspend fun getSession(input: GetSessionRequest): GetSessionResponse {
        val op = SdkHttpOperation.build<GetSessionRequest, GetSessionResponse> {
            serializer = GetSessionOperationSerializer()
            deserializer = GetSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about assistant associations.
     */
    override suspend fun listAssistantAssociations(input: ListAssistantAssociationsRequest): ListAssistantAssociationsResponse {
        val op = SdkHttpOperation.build<ListAssistantAssociationsRequest, ListAssistantAssociationsResponse> {
            serializer = ListAssistantAssociationsOperationSerializer()
            deserializer = ListAssistantAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssistantAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about assistants.
     */
    override suspend fun listAssistants(input: ListAssistantsRequest): ListAssistantsResponse {
        val op = SdkHttpOperation.build<ListAssistantsRequest, ListAssistantsResponse> {
            serializer = ListAssistantsOperationSerializer()
            deserializer = ListAssistantsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssistants"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the content.
     */
    override suspend fun listContents(input: ListContentsRequest): ListContentsResponse {
        val op = SdkHttpOperation.build<ListContentsRequest, ListContentsResponse> {
            serializer = ListContentsOperationSerializer()
            deserializer = ListContentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListContents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the knowledge bases.
     */
    override suspend fun listKnowledgeBases(input: ListKnowledgeBasesRequest): ListKnowledgeBasesResponse {
        val op = SdkHttpOperation.build<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse> {
            serializer = ListKnowledgeBasesOperationSerializer()
            deserializer = ListKnowledgeBasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListKnowledgeBases"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for the specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified recommendations from the specified assistant's queue of newly
     * available recommendations. You can use this API in conjunction with <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html">GetRecommendations and a waitTimeSeconds input for long-polling
     * behavior and avoiding duplicate recommendations.
     */
    override suspend fun notifyRecommendationsReceived(input: NotifyRecommendationsReceivedRequest): NotifyRecommendationsReceivedResponse {
        val op = SdkHttpOperation.build<NotifyRecommendationsReceivedRequest, NotifyRecommendationsReceivedResponse> {
            serializer = NotifyRecommendationsReceivedOperationSerializer()
            deserializer = NotifyRecommendationsReceivedOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "NotifyRecommendationsReceived"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Performs a manual search against the specified assistant. To retrieve recommendations for
     * an assistant, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html">GetRecommendations.
     */
    override suspend fun queryAssistant(input: QueryAssistantRequest): QueryAssistantResponse {
        val op = SdkHttpOperation.build<QueryAssistantRequest, QueryAssistantResponse> {
            serializer = QueryAssistantOperationSerializer()
            deserializer = QueryAssistantOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "QueryAssistant"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a URI template from a knowledge base.
     */
    override suspend fun removeKnowledgeBaseTemplateUri(input: RemoveKnowledgeBaseTemplateUriRequest): RemoveKnowledgeBaseTemplateUriResponse {
        val op = SdkHttpOperation.build<RemoveKnowledgeBaseTemplateUriRequest, RemoveKnowledgeBaseTemplateUriResponse> {
            serializer = RemoveKnowledgeBaseTemplateUriOperationSerializer()
            deserializer = RemoveKnowledgeBaseTemplateUriOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "RemoveKnowledgeBaseTemplateUri"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches for content in a specified knowledge base. Can be used to get a specific content
     * resource by its name.
     */
    override suspend fun searchContent(input: SearchContentRequest): SearchContentResponse {
        val op = SdkHttpOperation.build<SearchContentRequest, SearchContentResponse> {
            serializer = SearchContentOperationSerializer()
            deserializer = SearchContentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchContent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches for sessions.
     */
    override suspend fun searchSessions(input: SearchSessionsRequest): SearchSessionsResponse {
        val op = SdkHttpOperation.build<SearchSessionsRequest, SearchSessionsResponse> {
            serializer = SearchSessionsOperationSerializer()
            deserializer = SearchSessionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchSessions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get a URL to upload content to a knowledge base. To upload content, first make a PUT
     * request to the returned URL with your file, making sure to include the required headers. Then
     * use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateContent.html">CreateContent to finalize the content creation process or <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateContent.html">UpdateContent to modify an existing resource. You can only upload content to a
     * knowledge base of type CUSTOM.
     */
    override suspend fun startContentUpload(input: StartContentUploadRequest): StartContentUploadResponse {
        val op = SdkHttpOperation.build<StartContentUploadRequest, StartContentUploadResponse> {
            serializer = StartContentUploadOperationSerializer()
            deserializer = StartContentUploadOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartContentUpload"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified tags to the specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from the specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates information about the content.
     */
    override suspend fun updateContent(input: UpdateContentRequest): UpdateContentResponse {
        val op = SdkHttpOperation.build<UpdateContentRequest, UpdateContentResponse> {
            serializer = UpdateContentOperationSerializer()
            deserializer = UpdateContentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateContent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the template URI of a knowledge base. This is only supported for knowledge bases
     * of type EXTERNAL. Include a single variable in ${variable} format; this
     * interpolated by Wisdom using ingested content. For example, if you ingest a Salesforce
     * article, it has an Id value, and you can set the template URI to
     * https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav&#47;*${Id}*&#47;view.
     */
    override suspend fun updateKnowledgeBaseTemplateUri(input: UpdateKnowledgeBaseTemplateUriRequest): UpdateKnowledgeBaseTemplateUriResponse {
        val op = SdkHttpOperation.build<UpdateKnowledgeBaseTemplateUriRequest, UpdateKnowledgeBaseTemplateUriResponse> {
            serializer = UpdateKnowledgeBaseTemplateUriOperationSerializer()
            deserializer = UpdateKnowledgeBaseTemplateUriOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateKnowledgeBaseTemplateUri"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "wisdom"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
