// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wisdom

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.wisdom.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.wisdom.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucketOptions

/**
 * All Amazon Connect Wisdom functionality is accessible using the API. For example, you can create an
 * assistant and a knowledge base.
 *
 * Some more advanced features are only accessible using the Wisdom API. For example, you
 * can manually manage content by uploading custom files and control their lifecycle.
 */
interface WisdomClient : SdkClient {

    override val serviceName: String
        get() = "Wisdom"
    /**
     * WisdomClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): WisdomClient {
            val config = Config.Builder().apply(block).build()
            return DefaultWisdomClient(config)
        }

        operator fun invoke(config: Config): WisdomClient = DefaultWisdomClient(config)

        /**
         * Construct a [WisdomClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): WisdomClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultWisdomClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an Amazon Connect Wisdom assistant.
     */
    suspend fun createAssistant(input: CreateAssistantRequest): CreateAssistantResponse

    /**
     * Creates an Amazon Connect Wisdom assistant.
     */
    suspend fun createAssistant(block: CreateAssistantRequest.Builder.() -> Unit) = createAssistant(CreateAssistantRequest.Builder().apply(block).build())

    /**
     * Creates an association between an Amazon Connect Wisdom assistant and another resource. Currently, the
     * only supported association is with a knowledge base. An assistant can have only a single
     * association.
     */
    suspend fun createAssistantAssociation(input: CreateAssistantAssociationRequest): CreateAssistantAssociationResponse

    /**
     * Creates an association between an Amazon Connect Wisdom assistant and another resource. Currently, the
     * only supported association is with a knowledge base. An assistant can have only a single
     * association.
     */
    suspend fun createAssistantAssociation(block: CreateAssistantAssociationRequest.Builder.() -> Unit) = createAssistantAssociation(CreateAssistantAssociationRequest.Builder().apply(block).build())

    /**
     * Creates Wisdom content. Before to calling this API, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload to
     * upload an asset.
     */
    suspend fun createContent(input: CreateContentRequest): CreateContentResponse

    /**
     * Creates Wisdom content. Before to calling this API, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload to
     * upload an asset.
     */
    suspend fun createContent(block: CreateContentRequest.Builder.() -> Unit) = createContent(CreateContentRequest.Builder().apply(block).build())

    /**
     * Creates a knowledge base.
     *
     * When using this API, you cannot reuse <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations
     * DataIntegrations with external knowledge bases such as Salesforce and ServiceNow. If you do,
     * you'll get an InvalidRequestException error.
     *
     * For example, you're programmatically managing your external knowledge base, and you want
     * to add or remove one of the fields that is being ingested from Salesforce. Do the
     * following:
     * <ol>
     *
     * Call <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteKnowledgeBase.html">DeleteKnowledgeBase.
     *
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">DeleteDataIntegration.
     *
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration to recreate the DataIntegration or a create different
     * one.
     *
     * Call CreateKnowledgeBase.
     *
     * </ol>
     */
    suspend fun createKnowledgeBase(input: CreateKnowledgeBaseRequest): CreateKnowledgeBaseResponse

    /**
     * Creates a knowledge base.
     *
     * When using this API, you cannot reuse <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations
     * DataIntegrations with external knowledge bases such as Salesforce and ServiceNow. If you do,
     * you'll get an InvalidRequestException error.
     *
     * For example, you're programmatically managing your external knowledge base, and you want
     * to add or remove one of the fields that is being ingested from Salesforce. Do the
     * following:
     * <ol>
     *
     * Call <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteKnowledgeBase.html">DeleteKnowledgeBase.
     *
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">DeleteDataIntegration.
     *
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration to recreate the DataIntegration or a create different
     * one.
     *
     * Call CreateKnowledgeBase.
     *
     * </ol>
     */
    suspend fun createKnowledgeBase(block: CreateKnowledgeBaseRequest.Builder.() -> Unit) = createKnowledgeBase(CreateKnowledgeBaseRequest.Builder().apply(block).build())

    /**
     * Creates a session. A session is a contextual container used for generating
     * recommendations. Amazon Connect creates a new Wisdom session for each contact on which Wisdom is
     * enabled.
     */
    suspend fun createSession(input: CreateSessionRequest): CreateSessionResponse

    /**
     * Creates a session. A session is a contextual container used for generating
     * recommendations. Amazon Connect creates a new Wisdom session for each contact on which Wisdom is
     * enabled.
     */
    suspend fun createSession(block: CreateSessionRequest.Builder.() -> Unit) = createSession(CreateSessionRequest.Builder().apply(block).build())

    /**
     * Deletes an assistant.
     */
    suspend fun deleteAssistant(input: DeleteAssistantRequest): DeleteAssistantResponse

    /**
     * Deletes an assistant.
     */
    suspend fun deleteAssistant(block: DeleteAssistantRequest.Builder.() -> Unit) = deleteAssistant(DeleteAssistantRequest.Builder().apply(block).build())

    /**
     * Deletes an assistant association.
     */
    suspend fun deleteAssistantAssociation(input: DeleteAssistantAssociationRequest): DeleteAssistantAssociationResponse

    /**
     * Deletes an assistant association.
     */
    suspend fun deleteAssistantAssociation(block: DeleteAssistantAssociationRequest.Builder.() -> Unit) = deleteAssistantAssociation(DeleteAssistantAssociationRequest.Builder().apply(block).build())

    /**
     * Deletes the content.
     */
    suspend fun deleteContent(input: DeleteContentRequest): DeleteContentResponse

    /**
     * Deletes the content.
     */
    suspend fun deleteContent(block: DeleteContentRequest.Builder.() -> Unit) = deleteContent(DeleteContentRequest.Builder().apply(block).build())

    /**
     * Deletes the knowledge base.
     *
     * When you use this API to delete an external knowledge base such as Salesforce or
     * ServiceNow, you must also delete the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations DataIntegration.
     * This is because you can't reuse the DataIntegration after it's been associated with an
     * external knowledge base. However, you can delete and recreate it. See <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">DeleteDataIntegration and <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration in the Amazon AppIntegrations API
     * Reference.
     */
    suspend fun deleteKnowledgeBase(input: DeleteKnowledgeBaseRequest): DeleteKnowledgeBaseResponse

    /**
     * Deletes the knowledge base.
     *
     * When you use this API to delete an external knowledge base such as Salesforce or
     * ServiceNow, you must also delete the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations DataIntegration.
     * This is because you can't reuse the DataIntegration after it's been associated with an
     * external knowledge base. However, you can delete and recreate it. See <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">DeleteDataIntegration and <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration in the Amazon AppIntegrations API
     * Reference.
     */
    suspend fun deleteKnowledgeBase(block: DeleteKnowledgeBaseRequest.Builder.() -> Unit) = deleteKnowledgeBase(DeleteKnowledgeBaseRequest.Builder().apply(block).build())

    /**
     * Retrieves information about an assistant.
     */
    suspend fun getAssistant(input: GetAssistantRequest): GetAssistantResponse

    /**
     * Retrieves information about an assistant.
     */
    suspend fun getAssistant(block: GetAssistantRequest.Builder.() -> Unit) = getAssistant(GetAssistantRequest.Builder().apply(block).build())

    /**
     * Retrieves information about an assistant association.
     */
    suspend fun getAssistantAssociation(input: GetAssistantAssociationRequest): GetAssistantAssociationResponse

    /**
     * Retrieves information about an assistant association.
     */
    suspend fun getAssistantAssociation(block: GetAssistantAssociationRequest.Builder.() -> Unit) = getAssistantAssociation(GetAssistantAssociationRequest.Builder().apply(block).build())

    /**
     * Retrieves content, including a pre-signed URL to download the content.
     */
    suspend fun getContent(input: GetContentRequest): GetContentResponse

    /**
     * Retrieves content, including a pre-signed URL to download the content.
     */
    suspend fun getContent(block: GetContentRequest.Builder.() -> Unit) = getContent(GetContentRequest.Builder().apply(block).build())

    /**
     * Retrieves summary information about the content.
     */
    suspend fun getContentSummary(input: GetContentSummaryRequest): GetContentSummaryResponse

    /**
     * Retrieves summary information about the content.
     */
    suspend fun getContentSummary(block: GetContentSummaryRequest.Builder.() -> Unit) = getContentSummary(GetContentSummaryRequest.Builder().apply(block).build())

    /**
     * Retrieves information about the knowledge base.
     */
    suspend fun getKnowledgeBase(input: GetKnowledgeBaseRequest): GetKnowledgeBaseResponse

    /**
     * Retrieves information about the knowledge base.
     */
    suspend fun getKnowledgeBase(block: GetKnowledgeBaseRequest.Builder.() -> Unit) = getKnowledgeBase(GetKnowledgeBaseRequest.Builder().apply(block).build())

    /**
     * Retrieves recommendations for the specified session. To avoid retrieving the same
     * recommendations in subsequent calls, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_NotifyRecommendationsReceived.html">NotifyRecommendationsReceived. This API supports long-polling behavior with the
     * waitTimeSeconds parameter. Short poll is the default behavior and only returns
     * recommendations already available. To perform a manual query against an assistant, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_QueryAssistant.html">QueryAssistant.
     */
    suspend fun getRecommendations(input: GetRecommendationsRequest): GetRecommendationsResponse

    /**
     * Retrieves recommendations for the specified session. To avoid retrieving the same
     * recommendations in subsequent calls, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_NotifyRecommendationsReceived.html">NotifyRecommendationsReceived. This API supports long-polling behavior with the
     * waitTimeSeconds parameter. Short poll is the default behavior and only returns
     * recommendations already available. To perform a manual query against an assistant, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_QueryAssistant.html">QueryAssistant.
     */
    suspend fun getRecommendations(block: GetRecommendationsRequest.Builder.() -> Unit) = getRecommendations(GetRecommendationsRequest.Builder().apply(block).build())

    /**
     * Retrieves information for a specified session.
     */
    suspend fun getSession(input: GetSessionRequest): GetSessionResponse

    /**
     * Retrieves information for a specified session.
     */
    suspend fun getSession(block: GetSessionRequest.Builder.() -> Unit) = getSession(GetSessionRequest.Builder().apply(block).build())

    /**
     * Lists information about assistant associations.
     */
    suspend fun listAssistantAssociations(input: ListAssistantAssociationsRequest): ListAssistantAssociationsResponse

    /**
     * Lists information about assistant associations.
     */
    suspend fun listAssistantAssociations(block: ListAssistantAssociationsRequest.Builder.() -> Unit) = listAssistantAssociations(ListAssistantAssociationsRequest.Builder().apply(block).build())

    /**
     * Lists information about assistants.
     */
    suspend fun listAssistants(input: ListAssistantsRequest): ListAssistantsResponse

    /**
     * Lists information about assistants.
     */
    suspend fun listAssistants(block: ListAssistantsRequest.Builder.() -> Unit) = listAssistants(ListAssistantsRequest.Builder().apply(block).build())

    /**
     * Lists the content.
     */
    suspend fun listContents(input: ListContentsRequest): ListContentsResponse

    /**
     * Lists the content.
     */
    suspend fun listContents(block: ListContentsRequest.Builder.() -> Unit) = listContents(ListContentsRequest.Builder().apply(block).build())

    /**
     * Lists the knowledge bases.
     */
    suspend fun listKnowledgeBases(input: ListKnowledgeBasesRequest): ListKnowledgeBasesResponse

    /**
     * Lists the knowledge bases.
     */
    suspend fun listKnowledgeBases(block: ListKnowledgeBasesRequest.Builder.() -> Unit) = listKnowledgeBases(ListKnowledgeBasesRequest.Builder().apply(block).build())

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Removes the specified recommendations from the specified assistant's queue of newly
     * available recommendations. You can use this API in conjunction with <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html">GetRecommendations and a waitTimeSeconds input for long-polling
     * behavior and avoiding duplicate recommendations.
     */
    suspend fun notifyRecommendationsReceived(input: NotifyRecommendationsReceivedRequest): NotifyRecommendationsReceivedResponse

    /**
     * Removes the specified recommendations from the specified assistant's queue of newly
     * available recommendations. You can use this API in conjunction with <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html">GetRecommendations and a waitTimeSeconds input for long-polling
     * behavior and avoiding duplicate recommendations.
     */
    suspend fun notifyRecommendationsReceived(block: NotifyRecommendationsReceivedRequest.Builder.() -> Unit) = notifyRecommendationsReceived(NotifyRecommendationsReceivedRequest.Builder().apply(block).build())

    /**
     * Performs a manual search against the specified assistant. To retrieve recommendations for
     * an assistant, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html">GetRecommendations.
     */
    suspend fun queryAssistant(input: QueryAssistantRequest): QueryAssistantResponse

    /**
     * Performs a manual search against the specified assistant. To retrieve recommendations for
     * an assistant, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html">GetRecommendations.
     */
    suspend fun queryAssistant(block: QueryAssistantRequest.Builder.() -> Unit) = queryAssistant(QueryAssistantRequest.Builder().apply(block).build())

    /**
     * Removes a URI template from a knowledge base.
     */
    suspend fun removeKnowledgeBaseTemplateUri(input: RemoveKnowledgeBaseTemplateUriRequest): RemoveKnowledgeBaseTemplateUriResponse

    /**
     * Removes a URI template from a knowledge base.
     */
    suspend fun removeKnowledgeBaseTemplateUri(block: RemoveKnowledgeBaseTemplateUriRequest.Builder.() -> Unit) = removeKnowledgeBaseTemplateUri(RemoveKnowledgeBaseTemplateUriRequest.Builder().apply(block).build())

    /**
     * Searches for content in a specified knowledge base. Can be used to get a specific content
     * resource by its name.
     */
    suspend fun searchContent(input: SearchContentRequest): SearchContentResponse

    /**
     * Searches for content in a specified knowledge base. Can be used to get a specific content
     * resource by its name.
     */
    suspend fun searchContent(block: SearchContentRequest.Builder.() -> Unit) = searchContent(SearchContentRequest.Builder().apply(block).build())

    /**
     * Searches for sessions.
     */
    suspend fun searchSessions(input: SearchSessionsRequest): SearchSessionsResponse

    /**
     * Searches for sessions.
     */
    suspend fun searchSessions(block: SearchSessionsRequest.Builder.() -> Unit) = searchSessions(SearchSessionsRequest.Builder().apply(block).build())

    /**
     * Get a URL to upload content to a knowledge base. To upload content, first make a PUT
     * request to the returned URL with your file, making sure to include the required headers. Then
     * use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateContent.html">CreateContent to finalize the content creation process or <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateContent.html">UpdateContent to modify an existing resource. You can only upload content to a
     * knowledge base of type CUSTOM.
     */
    suspend fun startContentUpload(input: StartContentUploadRequest): StartContentUploadResponse

    /**
     * Get a URL to upload content to a knowledge base. To upload content, first make a PUT
     * request to the returned URL with your file, making sure to include the required headers. Then
     * use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateContent.html">CreateContent to finalize the content creation process or <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateContent.html">UpdateContent to modify an existing resource. You can only upload content to a
     * knowledge base of type CUSTOM.
     */
    suspend fun startContentUpload(block: StartContentUploadRequest.Builder.() -> Unit) = startContentUpload(StartContentUploadRequest.Builder().apply(block).build())

    /**
     * Adds the specified tags to the specified resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds the specified tags to the specified resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from the specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates information about the content.
     */
    suspend fun updateContent(input: UpdateContentRequest): UpdateContentResponse

    /**
     * Updates information about the content.
     */
    suspend fun updateContent(block: UpdateContentRequest.Builder.() -> Unit) = updateContent(UpdateContentRequest.Builder().apply(block).build())

    /**
     * Updates the template URI of a knowledge base. This is only supported for knowledge bases
     * of type EXTERNAL. Include a single variable in ${variable} format; this
     * interpolated by Wisdom using ingested content. For example, if you ingest a Salesforce
     * article, it has an Id value, and you can set the template URI to
     * https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav&#47;*${Id}*&#47;view.
     */
    suspend fun updateKnowledgeBaseTemplateUri(input: UpdateKnowledgeBaseTemplateUriRequest): UpdateKnowledgeBaseTemplateUriResponse

    /**
     * Updates the template URI of a knowledge base. This is only supported for knowledge bases
     * of type EXTERNAL. Include a single variable in ${variable} format; this
     * interpolated by Wisdom using ingested content. For example, if you ingest a Salesforce
     * article, it has an Id value, and you can set the template URI to
     * https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav&#47;*${Id}*&#47;view.
     */
    suspend fun updateKnowledgeBaseTemplateUri(block: UpdateKnowledgeBaseTemplateUriRequest.Builder.() -> Unit) = updateKnowledgeBaseTemplateUri(UpdateKnowledgeBaseTemplateUriRequest.Builder().apply(block).build())
}
