// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wisdom.model



/**
 * Configuration information for Amazon AppIntegrations to automatically ingest content.
 */
class AppIntegrationsConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content.
     */
    val appIntegrationArn: kotlin.String? = builder.appIntegrationArn
    /**
     * The fields from the source that are made available to your agents in Wisdom.
     *
     *
     * For <a href="https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"> Salesforce, you must include at least Id,
     * ArticleNumber, VersionNumber, Title,
     * PublishStatus, and IsDeleted.
     *
     * For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api"> ServiceNow, you must include at least number,
     * short_description, sys_mod_count, workflow_state,
     * and active.
     *
     *
     * Make sure to include additional field(s); these are indexed and used to source
     * recommendations.
     */
    val objectFields: List<String>? = builder.objectFields

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wisdom.model.AppIntegrationsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppIntegrationsConfiguration(")
        append("appIntegrationArn=$appIntegrationArn,")
        append("objectFields=$objectFields)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appIntegrationArn?.hashCode() ?: 0
        result = 31 * result + (objectFields?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppIntegrationsConfiguration

        if (appIntegrationArn != other.appIntegrationArn) return false
        if (objectFields != other.objectFields) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wisdom.model.AppIntegrationsConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content.
         */
        var appIntegrationArn: kotlin.String? = null
        /**
         * The fields from the source that are made available to your agents in Wisdom.
         *
         *
         * For <a href="https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"> Salesforce, you must include at least Id,
         * ArticleNumber, VersionNumber, Title,
         * PublishStatus, and IsDeleted.
         *
         * For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api"> ServiceNow, you must include at least number,
         * short_description, sys_mod_count, workflow_state,
         * and active.
         *
         *
         * Make sure to include additional field(s); these are indexed and used to source
         * recommendations.
         */
        var objectFields: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wisdom.model.AppIntegrationsConfiguration) : this() {
            this.appIntegrationArn = x.appIntegrationArn
            this.objectFields = x.objectFields
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wisdom.model.AppIntegrationsConfiguration = AppIntegrationsConfiguration(this)
    }
}
