// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wisdom.model



/**
 * Summary information about the assistant association.
 */
class AssistantAssociationSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Wisdom assistant
     */
    val assistantArn: kotlin.String? = builder.assistantArn
    /**
     * The Amazon Resource Name (ARN) of the assistant association.
     */
    val assistantAssociationArn: kotlin.String? = builder.assistantAssociationArn
    /**
     * The identifier of the assistant association.
     */
    val assistantAssociationId: kotlin.String? = builder.assistantAssociationId
    /**
     * The identifier of the Wisdom assistant.
     */
    val assistantId: kotlin.String? = builder.assistantId
    /**
     * The association data.
     */
    val associationData: aws.sdk.kotlin.services.wisdom.model.AssistantAssociationOutputData? = builder.associationData
    /**
     * The type of association.
     */
    val associationType: aws.sdk.kotlin.services.wisdom.model.AssociationType? = builder.associationType
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wisdom.model.AssistantAssociationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssistantAssociationSummary(")
        append("assistantArn=$assistantArn,")
        append("assistantAssociationArn=$assistantAssociationArn,")
        append("assistantAssociationId=$assistantAssociationId,")
        append("assistantId=$assistantId,")
        append("associationData=$associationData,")
        append("associationType=$associationType,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assistantArn?.hashCode() ?: 0
        result = 31 * result + (assistantAssociationArn?.hashCode() ?: 0)
        result = 31 * result + (assistantAssociationId?.hashCode() ?: 0)
        result = 31 * result + (assistantId?.hashCode() ?: 0)
        result = 31 * result + (associationData?.hashCode() ?: 0)
        result = 31 * result + (associationType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssistantAssociationSummary

        if (assistantArn != other.assistantArn) return false
        if (assistantAssociationArn != other.assistantAssociationArn) return false
        if (assistantAssociationId != other.assistantAssociationId) return false
        if (assistantId != other.assistantId) return false
        if (associationData != other.associationData) return false
        if (associationType != other.associationType) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wisdom.model.AssistantAssociationSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Wisdom assistant
         */
        var assistantArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the assistant association.
         */
        var assistantAssociationArn: kotlin.String? = null
        /**
         * The identifier of the assistant association.
         */
        var assistantAssociationId: kotlin.String? = null
        /**
         * The identifier of the Wisdom assistant.
         */
        var assistantId: kotlin.String? = null
        /**
         * The association data.
         */
        var associationData: aws.sdk.kotlin.services.wisdom.model.AssistantAssociationOutputData? = null
        /**
         * The type of association.
         */
        var associationType: aws.sdk.kotlin.services.wisdom.model.AssociationType? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wisdom.model.AssistantAssociationSummary) : this() {
            this.assistantArn = x.assistantArn
            this.assistantAssociationArn = x.assistantAssociationArn
            this.assistantAssociationId = x.assistantAssociationId
            this.assistantId = x.assistantId
            this.associationData = x.associationData
            this.associationType = x.associationType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wisdom.model.AssistantAssociationSummary = AssistantAssociationSummary(this)
    }
}
