// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wisdom.model



/**
 * Summary information about the content.
 */
class ContentSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the content.
     */
    val contentArn: kotlin.String? = builder.contentArn
    /**
     * The identifier of the content.
     */
    val contentId: kotlin.String? = builder.contentId
    /**
     * The media type of the content.
     */
    val contentType: kotlin.String? = builder.contentType
    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    val knowledgeBaseArn: kotlin.String? = builder.knowledgeBaseArn
    /**
     * The the identifier of the knowledge base.
     */
    val knowledgeBaseId: kotlin.String? = builder.knowledgeBaseId
    /**
     * A key/value map to store attributes without affecting tagging or recommendations.
     * For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.
     */
    val metadata: Map<String, String>? = builder.metadata
    /**
     * The name of the content.
     */
    val name: kotlin.String? = builder.name
    /**
     * The identifier of the revision of the content.
     */
    val revisionId: kotlin.String? = builder.revisionId
    /**
     * The status of the content.
     */
    val status: aws.sdk.kotlin.services.wisdom.model.ContentStatus? = builder.status
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The title of the content.
     */
    val title: kotlin.String? = builder.title

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wisdom.model.ContentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContentSummary(")
        append("contentArn=$contentArn,")
        append("contentId=$contentId,")
        append("contentType=$contentType,")
        append("knowledgeBaseArn=$knowledgeBaseArn,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("metadata=$metadata,")
        append("name=$name,")
        append("revisionId=$revisionId,")
        append("status=$status,")
        append("tags=$tags,")
        append("title=$title)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentArn?.hashCode() ?: 0
        result = 31 * result + (contentId?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (knowledgeBaseArn?.hashCode() ?: 0)
        result = 31 * result + (knowledgeBaseId?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContentSummary

        if (contentArn != other.contentArn) return false
        if (contentId != other.contentId) return false
        if (contentType != other.contentType) return false
        if (knowledgeBaseArn != other.knowledgeBaseArn) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (metadata != other.metadata) return false
        if (name != other.name) return false
        if (revisionId != other.revisionId) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (title != other.title) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wisdom.model.ContentSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the content.
         */
        var contentArn: kotlin.String? = null
        /**
         * The identifier of the content.
         */
        var contentId: kotlin.String? = null
        /**
         * The media type of the content.
         */
        var contentType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the knowledge base.
         */
        var knowledgeBaseArn: kotlin.String? = null
        /**
         * The the identifier of the knowledge base.
         */
        var knowledgeBaseId: kotlin.String? = null
        /**
         * A key/value map to store attributes without affecting tagging or recommendations.
         * For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.
         */
        var metadata: Map<String, String>? = null
        /**
         * The name of the content.
         */
        var name: kotlin.String? = null
        /**
         * The identifier of the revision of the content.
         */
        var revisionId: kotlin.String? = null
        /**
         * The status of the content.
         */
        var status: aws.sdk.kotlin.services.wisdom.model.ContentStatus? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        var tags: Map<String, String>? = null
        /**
         * The title of the content.
         */
        var title: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wisdom.model.ContentSummary) : this() {
            this.contentArn = x.contentArn
            this.contentId = x.contentId
            this.contentType = x.contentType
            this.knowledgeBaseArn = x.knowledgeBaseArn
            this.knowledgeBaseId = x.knowledgeBaseId
            this.metadata = x.metadata
            this.name = x.name
            this.revisionId = x.revisionId
            this.status = x.status
            this.tags = x.tags
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wisdom.model.ContentSummary = ContentSummary(this)
    }
}
