// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wisdom.model



class CreateContentRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    val knowledgeBaseId: kotlin.String? = builder.knowledgeBaseId
    /**
     * A key/value map to store attributes without affecting tagging or recommendations.
     * For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.
     */
    val metadata: Map<String, String>? = builder.metadata
    /**
     * The name of the content. Each piece of content in a knowledge base must have a unique
     * name. You can retrieve a piece of content using only its knowledge base and its name with the
     * <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html">SearchContent API.
     */
    val name: kotlin.String? = builder.name
    /**
     * The URI you want to use for the article. If the knowledge base has a templateUri, setting
     * this argument overrides it for this piece of content.
     */
    val overrideLinkOutUri: kotlin.String? = builder.overrideLinkOutUri
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The title of the content. If not set, the title is equal to the name.
     */
    val title: kotlin.String? = builder.title
    /**
     * A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload.
     */
    val uploadId: kotlin.String? = builder.uploadId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wisdom.model.CreateContentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateContentRequest(")
        append("clientToken=$clientToken,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("metadata=$metadata,")
        append("name=$name,")
        append("overrideLinkOutUri=$overrideLinkOutUri,")
        append("tags=$tags,")
        append("title=$title,")
        append("uploadId=$uploadId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (knowledgeBaseId?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (overrideLinkOutUri?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (uploadId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateContentRequest

        if (clientToken != other.clientToken) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (metadata != other.metadata) return false
        if (name != other.name) return false
        if (overrideLinkOutUri != other.overrideLinkOutUri) return false
        if (tags != other.tags) return false
        if (title != other.title) return false
        if (uploadId != other.uploadId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wisdom.model.CreateContentRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request.
         */
        var clientToken: kotlin.String? = null
        /**
         * The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        var knowledgeBaseId: kotlin.String? = null
        /**
         * A key/value map to store attributes without affecting tagging or recommendations.
         * For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.
         */
        var metadata: Map<String, String>? = null
        /**
         * The name of the content. Each piece of content in a knowledge base must have a unique
         * name. You can retrieve a piece of content using only its knowledge base and its name with the
         * <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html">SearchContent API.
         */
        var name: kotlin.String? = null
        /**
         * The URI you want to use for the article. If the knowledge base has a templateUri, setting
         * this argument overrides it for this piece of content.
         */
        var overrideLinkOutUri: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        var tags: Map<String, String>? = null
        /**
         * The title of the content. If not set, the title is equal to the name.
         */
        var title: kotlin.String? = null
        /**
         * A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload.
         */
        var uploadId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wisdom.model.CreateContentRequest) : this() {
            this.clientToken = x.clientToken
            this.knowledgeBaseId = x.knowledgeBaseId
            this.metadata = x.metadata
            this.name = x.name
            this.overrideLinkOutUri = x.overrideLinkOutUri
            this.tags = x.tags
            this.title = x.title
            this.uploadId = x.uploadId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wisdom.model.CreateContentRequest = CreateContentRequest(this)
    }
}
