// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wisdom.model



class GetRecommendationsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    val assistantId: kotlin.String? = builder.assistantId
    /**
     * The maximum number of results to return per page.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    val sessionId: kotlin.String? = builder.sessionId
    /**
     * The duration (in seconds) for which the call waits for a recommendation to be made
     * available before returning. If a recommendation is available, the call returns sooner than
     * WaitTimeSeconds. If no messages are available and the wait time expires, the
     * call returns successfully with an empty list.
     */
    val waitTimeSeconds: kotlin.Int = builder.waitTimeSeconds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wisdom.model.GetRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRecommendationsRequest(")
        append("assistantId=$assistantId,")
        append("maxResults=$maxResults,")
        append("sessionId=$sessionId,")
        append("waitTimeSeconds=$waitTimeSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assistantId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (waitTimeSeconds)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRecommendationsRequest

        if (assistantId != other.assistantId) return false
        if (maxResults != other.maxResults) return false
        if (sessionId != other.sessionId) return false
        if (waitTimeSeconds != other.waitTimeSeconds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wisdom.model.GetRecommendationsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        var assistantId: kotlin.String? = null
        /**
         * The maximum number of results to return per page.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        var sessionId: kotlin.String? = null
        /**
         * The duration (in seconds) for which the call waits for a recommendation to be made
         * available before returning. If a recommendation is available, the call returns sooner than
         * WaitTimeSeconds. If no messages are available and the wait time expires, the
         * call returns successfully with an empty list.
         */
        var waitTimeSeconds: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wisdom.model.GetRecommendationsRequest) : this() {
            this.assistantId = x.assistantId
            this.maxResults = x.maxResults
            this.sessionId = x.sessionId
            this.waitTimeSeconds = x.waitTimeSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wisdom.model.GetRecommendationsRequest = GetRecommendationsRequest(this)
    }
}
