// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wisdom.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the knowledge base.
 */
class KnowledgeBaseData private constructor(builder: Builder) {
    /**
     * The description.
     */
    val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    val knowledgeBaseArn: kotlin.String? = builder.knowledgeBaseArn
    /**
     * The the identifier of the knowledge base.
     */
    val knowledgeBaseId: kotlin.String? = builder.knowledgeBaseId
    /**
     * The type of knowledge base.
     */
    val knowledgeBaseType: aws.sdk.kotlin.services.wisdom.model.KnowledgeBaseType? = builder.knowledgeBaseType
    /**
     * An epoch timestamp indicating the most recent content modification inside the knowledge
     * base. If no content exists in a knowledge base, this value is unset.
     */
    val lastContentModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastContentModificationTime
    /**
     * The name of the knowledge base.
     */
    val name: kotlin.String? = builder.name
    /**
     * Information about how to render the content.
     */
    val renderingConfiguration: aws.sdk.kotlin.services.wisdom.model.RenderingConfiguration? = builder.renderingConfiguration
    /**
     * The KMS key used for encryption.
     */
    val serverSideEncryptionConfiguration: aws.sdk.kotlin.services.wisdom.model.ServerSideEncryptionConfiguration? = builder.serverSideEncryptionConfiguration
    /**
     * Source configuration information about the knowledge base.
     */
    val sourceConfiguration: aws.sdk.kotlin.services.wisdom.model.SourceConfiguration? = builder.sourceConfiguration
    /**
     * The status of the knowledge base.
     */
    val status: aws.sdk.kotlin.services.wisdom.model.KnowledgeBaseStatus? = builder.status
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wisdom.model.KnowledgeBaseData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KnowledgeBaseData(")
        append("description=$description,")
        append("knowledgeBaseArn=$knowledgeBaseArn,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("knowledgeBaseType=$knowledgeBaseType,")
        append("lastContentModificationTime=$lastContentModificationTime,")
        append("name=$name,")
        append("renderingConfiguration=$renderingConfiguration,")
        append("serverSideEncryptionConfiguration=$serverSideEncryptionConfiguration,")
        append("sourceConfiguration=$sourceConfiguration,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (knowledgeBaseArn?.hashCode() ?: 0)
        result = 31 * result + (knowledgeBaseId?.hashCode() ?: 0)
        result = 31 * result + (knowledgeBaseType?.hashCode() ?: 0)
        result = 31 * result + (lastContentModificationTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (renderingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (sourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KnowledgeBaseData

        if (description != other.description) return false
        if (knowledgeBaseArn != other.knowledgeBaseArn) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (knowledgeBaseType != other.knowledgeBaseType) return false
        if (lastContentModificationTime != other.lastContentModificationTime) return false
        if (name != other.name) return false
        if (renderingConfiguration != other.renderingConfiguration) return false
        if (serverSideEncryptionConfiguration != other.serverSideEncryptionConfiguration) return false
        if (sourceConfiguration != other.sourceConfiguration) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wisdom.model.KnowledgeBaseData = Builder(this).apply(block).build()

    class Builder {
        /**
         * The description.
         */
        var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the knowledge base.
         */
        var knowledgeBaseArn: kotlin.String? = null
        /**
         * The the identifier of the knowledge base.
         */
        var knowledgeBaseId: kotlin.String? = null
        /**
         * The type of knowledge base.
         */
        var knowledgeBaseType: aws.sdk.kotlin.services.wisdom.model.KnowledgeBaseType? = null
        /**
         * An epoch timestamp indicating the most recent content modification inside the knowledge
         * base. If no content exists in a knowledge base, this value is unset.
         */
        var lastContentModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the knowledge base.
         */
        var name: kotlin.String? = null
        /**
         * Information about how to render the content.
         */
        var renderingConfiguration: aws.sdk.kotlin.services.wisdom.model.RenderingConfiguration? = null
        /**
         * The KMS key used for encryption.
         */
        var serverSideEncryptionConfiguration: aws.sdk.kotlin.services.wisdom.model.ServerSideEncryptionConfiguration? = null
        /**
         * Source configuration information about the knowledge base.
         */
        var sourceConfiguration: aws.sdk.kotlin.services.wisdom.model.SourceConfiguration? = null
        /**
         * The status of the knowledge base.
         */
        var status: aws.sdk.kotlin.services.wisdom.model.KnowledgeBaseStatus? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wisdom.model.KnowledgeBaseData) : this() {
            this.description = x.description
            this.knowledgeBaseArn = x.knowledgeBaseArn
            this.knowledgeBaseId = x.knowledgeBaseId
            this.knowledgeBaseType = x.knowledgeBaseType
            this.lastContentModificationTime = x.lastContentModificationTime
            this.name = x.name
            this.renderingConfiguration = x.renderingConfiguration
            this.serverSideEncryptionConfiguration = x.serverSideEncryptionConfiguration
            this.sourceConfiguration = x.sourceConfiguration
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wisdom.model.KnowledgeBaseData = KnowledgeBaseData(this)

        /**
         * construct an [aws.sdk.kotlin.services.wisdom.model.RenderingConfiguration] inside the given [block]
         */
        fun renderingConfiguration(block: aws.sdk.kotlin.services.wisdom.model.RenderingConfiguration.Builder.() -> kotlin.Unit) {
            this.renderingConfiguration = aws.sdk.kotlin.services.wisdom.model.RenderingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wisdom.model.ServerSideEncryptionConfiguration] inside the given [block]
         */
        fun serverSideEncryptionConfiguration(block: aws.sdk.kotlin.services.wisdom.model.ServerSideEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.serverSideEncryptionConfiguration = aws.sdk.kotlin.services.wisdom.model.ServerSideEncryptionConfiguration.invoke(block)
        }
    }
}
