// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wisdom.transform

import aws.sdk.kotlin.services.wisdom.model.CreateContentRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateContentOperationSerializer: HttpSerialize<CreateContentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateContentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "knowledgeBases",
                "${input.knowledgeBaseId}".encodeLabel(),
                "contents",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateContentOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeCreateContentOperationBody(context: ExecutionContext, input: CreateContentRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("metadata"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OVERRIDELINKOUTURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("overrideLinkOutUri"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TITLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("title"))
    val UPLOADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("uploadId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OVERRIDELINKOUTURI_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TITLE_DESCRIPTOR)
        field(UPLOADID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        if (input.metadata != null) {
            mapField(METADATA_DESCRIPTOR) {
                input.metadata.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.overrideLinkOutUri?.let { field(OVERRIDELINKOUTURI_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.title?.let { field(TITLE_DESCRIPTOR, it) }
        input.uploadId?.let { field(UPLOADID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
