// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wisdom.transform

import aws.sdk.kotlin.services.wisdom.model.SearchContentRequest
import aws.sdk.kotlin.services.wisdom.model.SearchExpression
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SearchContentOperationSerializer: HttpSerialize<SearchContentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SearchContentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "knowledgeBases",
                "${input.knowledgeBaseId}".encodeLabel(),
                "search",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.maxResults != null) append("maxResults", "${input.maxResults}")
                if (input.nextToken != null) append("nextToken", input.nextToken)
            }
        }

        val payload = serializeSearchContentOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeSearchContentOperationBody(context: ExecutionContext, input: SearchContentRequest): ByteArray {
    val serializer = JsonSerializer()
    val SEARCHEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("searchExpression"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SEARCHEXPRESSION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.searchExpression?.let { field(SEARCHEXPRESSION_DESCRIPTOR, it, ::serializeSearchExpressionDocument) }
    }
    return serializer.toByteArray()
}
