// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wisdom.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wisdom.model.StartContentUploadResponse
import aws.sdk.kotlin.services.wisdom.model.WisdomException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class StartContentUploadOperationDeserializer: HttpDeserialize<StartContentUploadResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartContentUploadResponse {
        if (!response.status.isSuccess()) {
            throwStartContentUploadError(context, response)
        }
        val builder = StartContentUploadResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartContentUploadOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStartContentUploadError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WisdomException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WisdomException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartContentUploadOperationBody(builder: StartContentUploadResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HEADERSTOINCLUDE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("headersToInclude"))
    val UPLOADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("uploadId"))
    val URL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("url"))
    val URLEXPIRY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("urlExpiry"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HEADERSTOINCLUDE_DESCRIPTOR)
        field(UPLOADID_DESCRIPTOR)
        field(URL_DESCRIPTOR)
        field(URLEXPIRY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HEADERSTOINCLUDE_DESCRIPTOR.index -> builder.headersToInclude =
                    deserializer.deserializeMap(HEADERSTOINCLUDE_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                UPLOADID_DESCRIPTOR.index -> builder.uploadId = deserializeString()
                URL_DESCRIPTOR.index -> builder.url = deserializeString()
                URLEXPIRY_DESCRIPTOR.index -> builder.urlExpiry = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
