// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wisdom.transform

import aws.sdk.kotlin.services.wisdom.model.UpdateContentRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateContentOperationSerializer: HttpSerialize<UpdateContentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateContentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "knowledgeBases",
                "${input.knowledgeBaseId}".encodeLabel(),
                "contents",
                "${input.contentId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateContentOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeUpdateContentOperationBody(context: ExecutionContext, input: UpdateContentRequest): ByteArray {
    val serializer = JsonSerializer()
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("metadata"))
    val OVERRIDELINKOUTURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("overrideLinkOutUri"))
    val REMOVEOVERRIDELINKOUTURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("removeOverrideLinkOutUri"))
    val REVISIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("revisionId"))
    val TITLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("title"))
    val UPLOADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("uploadId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(METADATA_DESCRIPTOR)
        field(OVERRIDELINKOUTURI_DESCRIPTOR)
        field(REMOVEOVERRIDELINKOUTURI_DESCRIPTOR)
        field(REVISIONID_DESCRIPTOR)
        field(TITLE_DESCRIPTOR)
        field(UPLOADID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.metadata != null) {
            mapField(METADATA_DESCRIPTOR) {
                input.metadata.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.overrideLinkOutUri?.let { field(OVERRIDELINKOUTURI_DESCRIPTOR, it) }
        input.removeOverrideLinkOutUri?.let { field(REMOVEOVERRIDELINKOUTURI_DESCRIPTOR, it) }
        input.revisionId?.let { field(REVISIONID_DESCRIPTOR, it) }
        input.title?.let { field(TITLE_DESCRIPTOR, it) }
        input.uploadId?.let { field(UPLOADID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
