// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.workdocs.model.*
import aws.sdk.kotlin.services.workdocs.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "WorkDocs"
const val ServiceApiVersion: String = "2016-05-01"
const val SdkVersion: String = "0.10.0-beta"

internal class DefaultWorkDocsClient(override val config: WorkDocsClient.Config) : WorkDocsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Aborts the upload of the specified document version that was previously initiated
     * by InitiateDocumentVersionUpload. The client should make this call
     * only when it no longer intends to upload the document version, or fails to do
     * so.
     */
    override suspend fun abortDocumentVersionUpload(input: AbortDocumentVersionUploadRequest): AbortDocumentVersionUploadResponse {
        val op = SdkHttpOperation.build<AbortDocumentVersionUploadRequest, AbortDocumentVersionUploadResponse> {
            serializer = AbortDocumentVersionUploadOperationSerializer()
            deserializer = AbortDocumentVersionUploadOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "AbortDocumentVersionUpload"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Activates the specified user. Only active users can access Amazon
     * WorkDocs.
     */
    override suspend fun activateUser(input: ActivateUserRequest): ActivateUserResponse {
        val op = SdkHttpOperation.build<ActivateUserRequest, ActivateUserResponse> {
            serializer = ActivateUserOperationSerializer()
            deserializer = ActivateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ActivateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a set of permissions for the specified folder or document. The resource
     * permissions are overwritten if the principals already have different
     * permissions.
     */
    override suspend fun addResourcePermissions(input: AddResourcePermissionsRequest): AddResourcePermissionsResponse {
        val op = SdkHttpOperation.build<AddResourcePermissionsRequest, AddResourcePermissionsResponse> {
            serializer = AddResourcePermissionsOperationSerializer()
            deserializer = AddResourcePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "AddResourcePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new comment to the specified document version.
     */
    override suspend fun createComment(input: CreateCommentRequest): CreateCommentResponse {
        val op = SdkHttpOperation.build<CreateCommentRequest, CreateCommentResponse> {
            serializer = CreateCommentOperationSerializer()
            deserializer = CreateCommentOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateComment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more custom properties to the specified resource (a folder, document,
     * or version).
     */
    override suspend fun createCustomMetadata(input: CreateCustomMetadataRequest): CreateCustomMetadataResponse {
        val op = SdkHttpOperation.build<CreateCustomMetadataRequest, CreateCustomMetadataResponse> {
            serializer = CreateCustomMetadataOperationSerializer()
            deserializer = CreateCustomMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomMetadata"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a folder with the specified name and parent folder.
     */
    override suspend fun createFolder(input: CreateFolderRequest): CreateFolderResponse {
        val op = SdkHttpOperation.build<CreateFolderRequest, CreateFolderResponse> {
            serializer = CreateFolderOperationSerializer()
            deserializer = CreateFolderOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateFolder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified list of labels to the given resource (a document or
     * folder)
     */
    override suspend fun createLabels(input: CreateLabelsRequest): CreateLabelsResponse {
        val op = SdkHttpOperation.build<CreateLabelsRequest, CreateLabelsResponse> {
            serializer = CreateLabelsOperationSerializer()
            deserializer = CreateLabelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLabels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a
     * confirmation message, and must confirm the subscription.
     * For more information, see <a href="https://docs.aws.amazon.com/workdocs/latest/developerguide/subscribe-notifications.html">Subscribe to
     * Notifications in the Amazon WorkDocs Developer
     * Guide.
     */
    override suspend fun createNotificationSubscription(input: CreateNotificationSubscriptionRequest): CreateNotificationSubscriptionResponse {
        val op = SdkHttpOperation.build<CreateNotificationSubscriptionRequest, CreateNotificationSubscriptionResponse> {
            serializer = CreateNotificationSubscriptionOperationSerializer()
            deserializer = CreateNotificationSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNotificationSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user in a Simple AD or Microsoft AD directory. The status of a newly
     * created user is "ACTIVE". New users can access Amazon WorkDocs.
     */
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializer = CreateUserOperationSerializer()
            deserializer = CreateUserOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deactivates the specified user, which revokes the user's access to Amazon
     * WorkDocs.
     */
    override suspend fun deactivateUser(input: DeactivateUserRequest): DeactivateUserResponse {
        val op = SdkHttpOperation.build<DeactivateUserRequest, DeactivateUserResponse> {
            serializer = DeactivateUserOperationSerializer()
            deserializer = DeactivateUserOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeactivateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified comment from the document version.
     */
    override suspend fun deleteComment(input: DeleteCommentRequest): DeleteCommentResponse {
        val op = SdkHttpOperation.build<DeleteCommentRequest, DeleteCommentResponse> {
            serializer = DeleteCommentOperationSerializer()
            deserializer = DeleteCommentOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteComment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes custom metadata from the specified resource.
     */
    override suspend fun deleteCustomMetadata(input: DeleteCustomMetadataRequest): DeleteCustomMetadataResponse {
        val op = SdkHttpOperation.build<DeleteCustomMetadataRequest, DeleteCustomMetadataResponse> {
            serializer = DeleteCustomMetadataOperationSerializer()
            deserializer = DeleteCustomMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCustomMetadata"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Permanently deletes the specified document and its associated metadata.
     */
    override suspend fun deleteDocument(input: DeleteDocumentRequest): DeleteDocumentResponse {
        val op = SdkHttpOperation.build<DeleteDocumentRequest, DeleteDocumentResponse> {
            serializer = DeleteDocumentOperationSerializer()
            deserializer = DeleteDocumentOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteDocument"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Permanently deletes the specified folder and its contents.
     */
    override suspend fun deleteFolder(input: DeleteFolderRequest): DeleteFolderResponse {
        val op = SdkHttpOperation.build<DeleteFolderRequest, DeleteFolderResponse> {
            serializer = DeleteFolderOperationSerializer()
            deserializer = DeleteFolderOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteFolder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the contents of the specified folder.
     */
    override suspend fun deleteFolderContents(input: DeleteFolderContentsRequest): DeleteFolderContentsResponse {
        val op = SdkHttpOperation.build<DeleteFolderContentsRequest, DeleteFolderContentsResponse> {
            serializer = DeleteFolderContentsOperationSerializer()
            deserializer = DeleteFolderContentsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteFolderContents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified list of labels from a resource.
     */
    override suspend fun deleteLabels(input: DeleteLabelsRequest): DeleteLabelsResponse {
        val op = SdkHttpOperation.build<DeleteLabelsRequest, DeleteLabelsResponse> {
            serializer = DeleteLabelsOperationSerializer()
            deserializer = DeleteLabelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLabels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified subscription from the specified organization.
     */
    override suspend fun deleteNotificationSubscription(input: DeleteNotificationSubscriptionRequest): DeleteNotificationSubscriptionResponse {
        val op = SdkHttpOperation.build<DeleteNotificationSubscriptionRequest, DeleteNotificationSubscriptionResponse> {
            serializer = DeleteNotificationSubscriptionOperationSerializer()
            deserializer = DeleteNotificationSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNotificationSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified user from a Simple AD or Microsoft AD directory.
     */
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializer = DeleteUserOperationSerializer()
            deserializer = DeleteUserOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the user activities in a specified time period.
     */
    override suspend fun describeActivities(input: DescribeActivitiesRequest): DescribeActivitiesResponse {
        val op = SdkHttpOperation.build<DescribeActivitiesRequest, DescribeActivitiesResponse> {
            serializer = DescribeActivitiesOperationSerializer()
            deserializer = DescribeActivitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeActivities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all the comments for the specified document version.
     */
    override suspend fun describeComments(input: DescribeCommentsRequest): DescribeCommentsResponse {
        val op = SdkHttpOperation.build<DescribeCommentsRequest, DescribeCommentsResponse> {
            serializer = DescribeCommentsOperationSerializer()
            deserializer = DescribeCommentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeComments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the document versions for the specified document.
     * By default, only active versions are returned.
     */
    override suspend fun describeDocumentVersions(input: DescribeDocumentVersionsRequest): DescribeDocumentVersionsResponse {
        val op = SdkHttpOperation.build<DescribeDocumentVersionsRequest, DescribeDocumentVersionsResponse> {
            serializer = DescribeDocumentVersionsOperationSerializer()
            deserializer = DescribeDocumentVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDocumentVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the contents of the specified folder, including its documents and
     * subfolders.
     * By default, Amazon WorkDocs returns the first 100 active document and folder
     * metadata items. If there are more results, the response includes a marker that you can
     * use to request the next set of results. You can also request initialized
     * documents.
     */
    override suspend fun describeFolderContents(input: DescribeFolderContentsRequest): DescribeFolderContentsResponse {
        val op = SdkHttpOperation.build<DescribeFolderContentsRequest, DescribeFolderContentsResponse> {
            serializer = DescribeFolderContentsOperationSerializer()
            deserializer = DescribeFolderContentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFolderContents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the groups specified by the query. Groups are defined by the underlying
     * Active Directory.
     */
    override suspend fun describeGroups(input: DescribeGroupsRequest): DescribeGroupsResponse {
        val op = SdkHttpOperation.build<DescribeGroupsRequest, DescribeGroupsResponse> {
            serializer = DescribeGroupsOperationSerializer()
            deserializer = DescribeGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the specified notification subscriptions.
     */
    override suspend fun describeNotificationSubscriptions(input: DescribeNotificationSubscriptionsRequest): DescribeNotificationSubscriptionsResponse {
        val op = SdkHttpOperation.build<DescribeNotificationSubscriptionsRequest, DescribeNotificationSubscriptionsResponse> {
            serializer = DescribeNotificationSubscriptionsOperationSerializer()
            deserializer = DescribeNotificationSubscriptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNotificationSubscriptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the permissions of a specified resource.
     */
    override suspend fun describeResourcePermissions(input: DescribeResourcePermissionsRequest): DescribeResourcePermissionsResponse {
        val op = SdkHttpOperation.build<DescribeResourcePermissionsRequest, DescribeResourcePermissionsResponse> {
            serializer = DescribeResourcePermissionsOperationSerializer()
            deserializer = DescribeResourcePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeResourcePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the current user's special folders; the RootFolder and the
     * RecycleBin. RootFolder is the root of user's files and
     * folders and RecycleBin is the root of recycled items. This is not a valid
     * action for SigV4 (administrative API) clients.
     * This action requires an authentication token. To get an authentication token,
     * register an application with Amazon WorkDocs. For more information, see <a href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications in the
     * Amazon
     * WorkDocs Developer Guide.
     */
    override suspend fun describeRootFolders(input: DescribeRootFoldersRequest): DescribeRootFoldersResponse {
        val op = SdkHttpOperation.build<DescribeRootFoldersRequest, DescribeRootFoldersResponse> {
            serializer = DescribeRootFoldersOperationSerializer()
            deserializer = DescribeRootFoldersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRootFolders"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified users. You can describe all users or filter the results
     * (for example, by status or organization).
     * By default, Amazon WorkDocs returns the first 24 active or pending users. If there
     * are more results, the response includes a marker that you can use to request the next
     * set of results.
     */
    override suspend fun describeUsers(input: DescribeUsersRequest): DescribeUsersResponse {
        val op = SdkHttpOperation.build<DescribeUsersRequest, DescribeUsersResponse> {
            serializer = DescribeUsersOperationSerializer()
            deserializer = DescribeUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details of the current user for whom the authentication token was
     * generated. This is not a valid action for SigV4 (administrative API) clients.
     * This action requires an authentication token. To get an authentication token,
     * register an application with Amazon WorkDocs. For more information, see <a href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications in the
     * Amazon
     * WorkDocs Developer Guide.
     */
    override suspend fun getCurrentUser(input: GetCurrentUserRequest): GetCurrentUserResponse {
        val op = SdkHttpOperation.build<GetCurrentUserRequest, GetCurrentUserResponse> {
            serializer = GetCurrentUserOperationSerializer()
            deserializer = GetCurrentUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCurrentUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details of a document.
     */
    override suspend fun getDocument(input: GetDocumentRequest): GetDocumentResponse {
        val op = SdkHttpOperation.build<GetDocumentRequest, GetDocumentResponse> {
            serializer = GetDocumentOperationSerializer()
            deserializer = GetDocumentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDocument"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the path information (the hierarchy from the root folder) for the
     * requested document.
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the
     * requested document and only includes the IDs of the parent folders in the path. You can
     * limit the maximum number of levels. You can also request the names of the parent
     * folders.
     */
    override suspend fun getDocumentPath(input: GetDocumentPathRequest): GetDocumentPathResponse {
        val op = SdkHttpOperation.build<GetDocumentPathRequest, GetDocumentPathResponse> {
            serializer = GetDocumentPathOperationSerializer()
            deserializer = GetDocumentPathOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDocumentPath"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves version metadata for the specified document.
     */
    override suspend fun getDocumentVersion(input: GetDocumentVersionRequest): GetDocumentVersionResponse {
        val op = SdkHttpOperation.build<GetDocumentVersionRequest, GetDocumentVersionResponse> {
            serializer = GetDocumentVersionOperationSerializer()
            deserializer = GetDocumentVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDocumentVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the metadata of the specified folder.
     */
    override suspend fun getFolder(input: GetFolderRequest): GetFolderResponse {
        val op = SdkHttpOperation.build<GetFolderRequest, GetFolderResponse> {
            serializer = GetFolderOperationSerializer()
            deserializer = GetFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFolder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the path information (the hierarchy from the root folder) for the
     * specified folder.
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the
     * requested folder and only includes the IDs of the parent folders in the path. You can
     * limit the maximum number of levels. You can also request the parent folder
     * names.
     */
    override suspend fun getFolderPath(input: GetFolderPathRequest): GetFolderPathResponse {
        val op = SdkHttpOperation.build<GetFolderPathRequest, GetFolderPathResponse> {
            serializer = GetFolderPathOperationSerializer()
            deserializer = GetFolderPathOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFolderPath"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a collection of resources, including folders and documents. The only
     * CollectionType supported is SHARED_WITH_ME.
     */
    override suspend fun getResources(input: GetResourcesRequest): GetResourcesResponse {
        val op = SdkHttpOperation.build<GetResourcesRequest, GetResourcesResponse> {
            serializer = GetResourcesOperationSerializer()
            deserializer = GetResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new document object and version object.
     * The client specifies the parent folder ID and name of the document to upload. The
     * ID is optionally specified when creating a new version of an existing document. This is
     * the first step to upload a document. Next, upload the document to the URL returned from
     * the call, and then call UpdateDocumentVersion.
     * To cancel the document upload, call AbortDocumentVersionUpload.
     */
    override suspend fun initiateDocumentVersionUpload(input: InitiateDocumentVersionUploadRequest): InitiateDocumentVersionUploadResponse {
        val op = SdkHttpOperation.build<InitiateDocumentVersionUploadRequest, InitiateDocumentVersionUploadResponse> {
            serializer = InitiateDocumentVersionUploadOperationSerializer()
            deserializer = InitiateDocumentVersionUploadOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "InitiateDocumentVersionUpload"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes all the permissions from the specified resource.
     */
    override suspend fun removeAllResourcePermissions(input: RemoveAllResourcePermissionsRequest): RemoveAllResourcePermissionsResponse {
        val op = SdkHttpOperation.build<RemoveAllResourcePermissionsRequest, RemoveAllResourcePermissionsResponse> {
            serializer = RemoveAllResourcePermissionsOperationSerializer()
            deserializer = RemoveAllResourcePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "RemoveAllResourcePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the permission for the specified principal from the specified
     * resource.
     */
    override suspend fun removeResourcePermission(input: RemoveResourcePermissionRequest): RemoveResourcePermissionResponse {
        val op = SdkHttpOperation.build<RemoveResourcePermissionRequest, RemoveResourcePermissionResponse> {
            serializer = RemoveResourcePermissionOperationSerializer()
            deserializer = RemoveResourcePermissionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "RemoveResourcePermission"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified attributes of a document. The user must have access to both
     * the document and its parent folder, if applicable.
     */
    override suspend fun updateDocument(input: UpdateDocumentRequest): UpdateDocumentResponse {
        val op = SdkHttpOperation.build<UpdateDocumentRequest, UpdateDocumentResponse> {
            serializer = UpdateDocumentOperationSerializer()
            deserializer = UpdateDocumentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDocument"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes the status of the document version to ACTIVE.
     * Amazon WorkDocs also sets its document container to ACTIVE. This is the last step
     * in a document upload, after the client uploads the document to an S3-presigned URL
     * returned by InitiateDocumentVersionUpload.
     */
    override suspend fun updateDocumentVersion(input: UpdateDocumentVersionRequest): UpdateDocumentVersionResponse {
        val op = SdkHttpOperation.build<UpdateDocumentVersionRequest, UpdateDocumentVersionResponse> {
            serializer = UpdateDocumentVersionOperationSerializer()
            deserializer = UpdateDocumentVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDocumentVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified attributes of the specified folder. The user must have access
     * to both the folder and its parent folder, if applicable.
     */
    override suspend fun updateFolder(input: UpdateFolderRequest): UpdateFolderResponse {
        val op = SdkHttpOperation.build<UpdateFolderRequest, UpdateFolderResponse> {
            serializer = UpdateFolderOperationSerializer()
            deserializer = UpdateFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFolder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified attributes of the specified user, and grants or revokes
     * administrative privileges to the Amazon WorkDocs site.
     */
    override suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse {
        val op = SdkHttpOperation.build<UpdateUserRequest, UpdateUserResponse> {
            serializer = UpdateUserOperationSerializer()
            deserializer = UpdateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workdocs"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
