// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.workdocs.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.workdocs.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * The WorkDocs API is designed for the following use cases:
 * File Migration: File migration applications are supported for users who
 * want to migrate their files from an on-premises or off-premises file system or
 * service. Users can insert files into a user directory structure, as well as
 * allow for basic metadata changes, such as modifications to the permissions of
 * files.
 * Security: Support security applications are supported for users who have
 * additional security needs, such as antivirus or data loss prevention. The API
 * actions, along with AWS CloudTrail, allow these applications to detect when
 * changes occur in Amazon WorkDocs. Then, the application can take the necessary
 * actions and replace the target file. If the target file violates the policy, the
 * application can also choose to email the user.
 * eDiscovery/Analytics: General administrative applications are supported,
 * such as eDiscovery and analytics. These applications can choose to mimic or
 * record the actions in an Amazon WorkDocs site, along with AWS CloudTrail, to
 * replicate data for eDiscovery, backup, or analytical applications.
 * All Amazon WorkDocs API actions are Amazon authenticated and certificate-signed.
 * They not only require the use of the AWS SDK, but also allow for the exclusive use of
 * IAM users and roles to help facilitate access, trust, and permission policies. By
 * creating a role and allowing an IAM user to access the Amazon WorkDocs site, the IAM
 * user gains full administrative visibility into the entire Amazon WorkDocs site (or as
 * set in the IAM policy). This includes, but is not limited to, the ability to modify file
 * permissions and upload any file to any user. This allows developers to perform the three
 * use cases above, as well as give users the ability to grant access on a selective basis
 * using the IAM model.
 */
interface WorkDocsClient : SdkClient {

    override val serviceName: String
        get() = "WorkDocs"
    /**
     * WorkDocsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): WorkDocsClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
                sdkLogMode = sharedConfig?.sdkLogMode ?: SdkLogMode.Default
            }.apply(block).build()
            return DefaultWorkDocsClient(config)
        }

        operator fun invoke(config: Config): WorkDocsClient = DefaultWorkDocsClient(config)

        /**
         * Construct a [WorkDocsClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): WorkDocsClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return WorkDocsClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Aborts the upload of the specified document version that was previously initiated
     * by InitiateDocumentVersionUpload. The client should make this call
     * only when it no longer intends to upload the document version, or fails to do
     * so.
     */
    suspend fun abortDocumentVersionUpload(input: AbortDocumentVersionUploadRequest): AbortDocumentVersionUploadResponse

    /**
     * Aborts the upload of the specified document version that was previously initiated
     * by InitiateDocumentVersionUpload. The client should make this call
     * only when it no longer intends to upload the document version, or fails to do
     * so.
     */
    suspend fun abortDocumentVersionUpload(block: AbortDocumentVersionUploadRequest.Builder.() -> Unit) = abortDocumentVersionUpload(AbortDocumentVersionUploadRequest.Builder().apply(block).build())

    /**
     * Activates the specified user. Only active users can access Amazon
     * WorkDocs.
     */
    suspend fun activateUser(input: ActivateUserRequest): ActivateUserResponse

    /**
     * Activates the specified user. Only active users can access Amazon
     * WorkDocs.
     */
    suspend fun activateUser(block: ActivateUserRequest.Builder.() -> Unit) = activateUser(ActivateUserRequest.Builder().apply(block).build())

    /**
     * Creates a set of permissions for the specified folder or document. The resource
     * permissions are overwritten if the principals already have different
     * permissions.
     */
    suspend fun addResourcePermissions(input: AddResourcePermissionsRequest): AddResourcePermissionsResponse

    /**
     * Creates a set of permissions for the specified folder or document. The resource
     * permissions are overwritten if the principals already have different
     * permissions.
     */
    suspend fun addResourcePermissions(block: AddResourcePermissionsRequest.Builder.() -> Unit) = addResourcePermissions(AddResourcePermissionsRequest.Builder().apply(block).build())

    /**
     * Adds a new comment to the specified document version.
     */
    suspend fun createComment(input: CreateCommentRequest): CreateCommentResponse

    /**
     * Adds a new comment to the specified document version.
     */
    suspend fun createComment(block: CreateCommentRequest.Builder.() -> Unit) = createComment(CreateCommentRequest.Builder().apply(block).build())

    /**
     * Adds one or more custom properties to the specified resource (a folder, document,
     * or version).
     */
    suspend fun createCustomMetadata(input: CreateCustomMetadataRequest): CreateCustomMetadataResponse

    /**
     * Adds one or more custom properties to the specified resource (a folder, document,
     * or version).
     */
    suspend fun createCustomMetadata(block: CreateCustomMetadataRequest.Builder.() -> Unit) = createCustomMetadata(CreateCustomMetadataRequest.Builder().apply(block).build())

    /**
     * Creates a folder with the specified name and parent folder.
     */
    suspend fun createFolder(input: CreateFolderRequest): CreateFolderResponse

    /**
     * Creates a folder with the specified name and parent folder.
     */
    suspend fun createFolder(block: CreateFolderRequest.Builder.() -> Unit) = createFolder(CreateFolderRequest.Builder().apply(block).build())

    /**
     * Adds the specified list of labels to the given resource (a document or
     * folder)
     */
    suspend fun createLabels(input: CreateLabelsRequest): CreateLabelsResponse

    /**
     * Adds the specified list of labels to the given resource (a document or
     * folder)
     */
    suspend fun createLabels(block: CreateLabelsRequest.Builder.() -> Unit) = createLabels(CreateLabelsRequest.Builder().apply(block).build())

    /**
     * Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a
     * confirmation message, and must confirm the subscription.
     * For more information, see <a href="https://docs.aws.amazon.com/workdocs/latest/developerguide/subscribe-notifications.html">Subscribe to
     * Notifications in the Amazon WorkDocs Developer
     * Guide.
     */
    suspend fun createNotificationSubscription(input: CreateNotificationSubscriptionRequest): CreateNotificationSubscriptionResponse

    /**
     * Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a
     * confirmation message, and must confirm the subscription.
     * For more information, see <a href="https://docs.aws.amazon.com/workdocs/latest/developerguide/subscribe-notifications.html">Subscribe to
     * Notifications in the Amazon WorkDocs Developer
     * Guide.
     */
    suspend fun createNotificationSubscription(block: CreateNotificationSubscriptionRequest.Builder.() -> Unit) = createNotificationSubscription(CreateNotificationSubscriptionRequest.Builder().apply(block).build())

    /**
     * Creates a user in a Simple AD or Microsoft AD directory. The status of a newly
     * created user is "ACTIVE". New users can access Amazon WorkDocs.
     */
    suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Creates a user in a Simple AD or Microsoft AD directory. The status of a newly
     * created user is "ACTIVE". New users can access Amazon WorkDocs.
     */
    suspend fun createUser(block: CreateUserRequest.Builder.() -> Unit) = createUser(CreateUserRequest.Builder().apply(block).build())

    /**
     * Deactivates the specified user, which revokes the user's access to Amazon
     * WorkDocs.
     */
    suspend fun deactivateUser(input: DeactivateUserRequest): DeactivateUserResponse

    /**
     * Deactivates the specified user, which revokes the user's access to Amazon
     * WorkDocs.
     */
    suspend fun deactivateUser(block: DeactivateUserRequest.Builder.() -> Unit) = deactivateUser(DeactivateUserRequest.Builder().apply(block).build())

    /**
     * Deletes the specified comment from the document version.
     */
    suspend fun deleteComment(input: DeleteCommentRequest): DeleteCommentResponse

    /**
     * Deletes the specified comment from the document version.
     */
    suspend fun deleteComment(block: DeleteCommentRequest.Builder.() -> Unit) = deleteComment(DeleteCommentRequest.Builder().apply(block).build())

    /**
     * Deletes custom metadata from the specified resource.
     */
    suspend fun deleteCustomMetadata(input: DeleteCustomMetadataRequest): DeleteCustomMetadataResponse

    /**
     * Deletes custom metadata from the specified resource.
     */
    suspend fun deleteCustomMetadata(block: DeleteCustomMetadataRequest.Builder.() -> Unit) = deleteCustomMetadata(DeleteCustomMetadataRequest.Builder().apply(block).build())

    /**
     * Permanently deletes the specified document and its associated metadata.
     */
    suspend fun deleteDocument(input: DeleteDocumentRequest): DeleteDocumentResponse

    /**
     * Permanently deletes the specified document and its associated metadata.
     */
    suspend fun deleteDocument(block: DeleteDocumentRequest.Builder.() -> Unit) = deleteDocument(DeleteDocumentRequest.Builder().apply(block).build())

    /**
     * Permanently deletes the specified folder and its contents.
     */
    suspend fun deleteFolder(input: DeleteFolderRequest): DeleteFolderResponse

    /**
     * Permanently deletes the specified folder and its contents.
     */
    suspend fun deleteFolder(block: DeleteFolderRequest.Builder.() -> Unit) = deleteFolder(DeleteFolderRequest.Builder().apply(block).build())

    /**
     * Deletes the contents of the specified folder.
     */
    suspend fun deleteFolderContents(input: DeleteFolderContentsRequest): DeleteFolderContentsResponse

    /**
     * Deletes the contents of the specified folder.
     */
    suspend fun deleteFolderContents(block: DeleteFolderContentsRequest.Builder.() -> Unit) = deleteFolderContents(DeleteFolderContentsRequest.Builder().apply(block).build())

    /**
     * Deletes the specified list of labels from a resource.
     */
    suspend fun deleteLabels(input: DeleteLabelsRequest): DeleteLabelsResponse

    /**
     * Deletes the specified list of labels from a resource.
     */
    suspend fun deleteLabels(block: DeleteLabelsRequest.Builder.() -> Unit) = deleteLabels(DeleteLabelsRequest.Builder().apply(block).build())

    /**
     * Deletes the specified subscription from the specified organization.
     */
    suspend fun deleteNotificationSubscription(input: DeleteNotificationSubscriptionRequest): DeleteNotificationSubscriptionResponse

    /**
     * Deletes the specified subscription from the specified organization.
     */
    suspend fun deleteNotificationSubscription(block: DeleteNotificationSubscriptionRequest.Builder.() -> Unit) = deleteNotificationSubscription(DeleteNotificationSubscriptionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified user from a Simple AD or Microsoft AD directory.
     */
    suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes the specified user from a Simple AD or Microsoft AD directory.
     */
    suspend fun deleteUser(block: DeleteUserRequest.Builder.() -> Unit) = deleteUser(DeleteUserRequest.Builder().apply(block).build())

    /**
     * Describes the user activities in a specified time period.
     */
    suspend fun describeActivities(input: DescribeActivitiesRequest): DescribeActivitiesResponse

    /**
     * Describes the user activities in a specified time period.
     */
    suspend fun describeActivities(block: DescribeActivitiesRequest.Builder.() -> Unit) = describeActivities(DescribeActivitiesRequest.Builder().apply(block).build())

    /**
     * List all the comments for the specified document version.
     */
    suspend fun describeComments(input: DescribeCommentsRequest): DescribeCommentsResponse

    /**
     * List all the comments for the specified document version.
     */
    suspend fun describeComments(block: DescribeCommentsRequest.Builder.() -> Unit) = describeComments(DescribeCommentsRequest.Builder().apply(block).build())

    /**
     * Retrieves the document versions for the specified document.
     * By default, only active versions are returned.
     */
    suspend fun describeDocumentVersions(input: DescribeDocumentVersionsRequest): DescribeDocumentVersionsResponse

    /**
     * Retrieves the document versions for the specified document.
     * By default, only active versions are returned.
     */
    suspend fun describeDocumentVersions(block: DescribeDocumentVersionsRequest.Builder.() -> Unit) = describeDocumentVersions(DescribeDocumentVersionsRequest.Builder().apply(block).build())

    /**
     * Describes the contents of the specified folder, including its documents and
     * subfolders.
     * By default, Amazon WorkDocs returns the first 100 active document and folder
     * metadata items. If there are more results, the response includes a marker that you can
     * use to request the next set of results. You can also request initialized
     * documents.
     */
    suspend fun describeFolderContents(input: DescribeFolderContentsRequest): DescribeFolderContentsResponse

    /**
     * Describes the contents of the specified folder, including its documents and
     * subfolders.
     * By default, Amazon WorkDocs returns the first 100 active document and folder
     * metadata items. If there are more results, the response includes a marker that you can
     * use to request the next set of results. You can also request initialized
     * documents.
     */
    suspend fun describeFolderContents(block: DescribeFolderContentsRequest.Builder.() -> Unit) = describeFolderContents(DescribeFolderContentsRequest.Builder().apply(block).build())

    /**
     * Describes the groups specified by the query. Groups are defined by the underlying
     * Active Directory.
     */
    suspend fun describeGroups(input: DescribeGroupsRequest): DescribeGroupsResponse

    /**
     * Describes the groups specified by the query. Groups are defined by the underlying
     * Active Directory.
     */
    suspend fun describeGroups(block: DescribeGroupsRequest.Builder.() -> Unit) = describeGroups(DescribeGroupsRequest.Builder().apply(block).build())

    /**
     * Lists the specified notification subscriptions.
     */
    suspend fun describeNotificationSubscriptions(input: DescribeNotificationSubscriptionsRequest): DescribeNotificationSubscriptionsResponse

    /**
     * Lists the specified notification subscriptions.
     */
    suspend fun describeNotificationSubscriptions(block: DescribeNotificationSubscriptionsRequest.Builder.() -> Unit) = describeNotificationSubscriptions(DescribeNotificationSubscriptionsRequest.Builder().apply(block).build())

    /**
     * Describes the permissions of a specified resource.
     */
    suspend fun describeResourcePermissions(input: DescribeResourcePermissionsRequest): DescribeResourcePermissionsResponse

    /**
     * Describes the permissions of a specified resource.
     */
    suspend fun describeResourcePermissions(block: DescribeResourcePermissionsRequest.Builder.() -> Unit) = describeResourcePermissions(DescribeResourcePermissionsRequest.Builder().apply(block).build())

    /**
     * Describes the current user's special folders; the RootFolder and the
     * RecycleBin. RootFolder is the root of user's files and
     * folders and RecycleBin is the root of recycled items. This is not a valid
     * action for SigV4 (administrative API) clients.
     * This action requires an authentication token. To get an authentication token,
     * register an application with Amazon WorkDocs. For more information, see <a href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications in the
     * Amazon
     * WorkDocs Developer Guide.
     */
    suspend fun describeRootFolders(input: DescribeRootFoldersRequest): DescribeRootFoldersResponse

    /**
     * Describes the current user's special folders; the RootFolder and the
     * RecycleBin. RootFolder is the root of user's files and
     * folders and RecycleBin is the root of recycled items. This is not a valid
     * action for SigV4 (administrative API) clients.
     * This action requires an authentication token. To get an authentication token,
     * register an application with Amazon WorkDocs. For more information, see <a href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications in the
     * Amazon
     * WorkDocs Developer Guide.
     */
    suspend fun describeRootFolders(block: DescribeRootFoldersRequest.Builder.() -> Unit) = describeRootFolders(DescribeRootFoldersRequest.Builder().apply(block).build())

    /**
     * Describes the specified users. You can describe all users or filter the results
     * (for example, by status or organization).
     * By default, Amazon WorkDocs returns the first 24 active or pending users. If there
     * are more results, the response includes a marker that you can use to request the next
     * set of results.
     */
    suspend fun describeUsers(input: DescribeUsersRequest): DescribeUsersResponse

    /**
     * Describes the specified users. You can describe all users or filter the results
     * (for example, by status or organization).
     * By default, Amazon WorkDocs returns the first 24 active or pending users. If there
     * are more results, the response includes a marker that you can use to request the next
     * set of results.
     */
    suspend fun describeUsers(block: DescribeUsersRequest.Builder.() -> Unit) = describeUsers(DescribeUsersRequest.Builder().apply(block).build())

    /**
     * Retrieves details of the current user for whom the authentication token was
     * generated. This is not a valid action for SigV4 (administrative API) clients.
     * This action requires an authentication token. To get an authentication token,
     * register an application with Amazon WorkDocs. For more information, see <a href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications in the
     * Amazon
     * WorkDocs Developer Guide.
     */
    suspend fun getCurrentUser(input: GetCurrentUserRequest): GetCurrentUserResponse

    /**
     * Retrieves details of the current user for whom the authentication token was
     * generated. This is not a valid action for SigV4 (administrative API) clients.
     * This action requires an authentication token. To get an authentication token,
     * register an application with Amazon WorkDocs. For more information, see <a href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access
     * Control for User Applications in the
     * Amazon
     * WorkDocs Developer Guide.
     */
    suspend fun getCurrentUser(block: GetCurrentUserRequest.Builder.() -> Unit) = getCurrentUser(GetCurrentUserRequest.Builder().apply(block).build())

    /**
     * Retrieves details of a document.
     */
    suspend fun getDocument(input: GetDocumentRequest): GetDocumentResponse

    /**
     * Retrieves details of a document.
     */
    suspend fun getDocument(block: GetDocumentRequest.Builder.() -> Unit) = getDocument(GetDocumentRequest.Builder().apply(block).build())

    /**
     * Retrieves the path information (the hierarchy from the root folder) for the
     * requested document.
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the
     * requested document and only includes the IDs of the parent folders in the path. You can
     * limit the maximum number of levels. You can also request the names of the parent
     * folders.
     */
    suspend fun getDocumentPath(input: GetDocumentPathRequest): GetDocumentPathResponse

    /**
     * Retrieves the path information (the hierarchy from the root folder) for the
     * requested document.
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the
     * requested document and only includes the IDs of the parent folders in the path. You can
     * limit the maximum number of levels. You can also request the names of the parent
     * folders.
     */
    suspend fun getDocumentPath(block: GetDocumentPathRequest.Builder.() -> Unit) = getDocumentPath(GetDocumentPathRequest.Builder().apply(block).build())

    /**
     * Retrieves version metadata for the specified document.
     */
    suspend fun getDocumentVersion(input: GetDocumentVersionRequest): GetDocumentVersionResponse

    /**
     * Retrieves version metadata for the specified document.
     */
    suspend fun getDocumentVersion(block: GetDocumentVersionRequest.Builder.() -> Unit) = getDocumentVersion(GetDocumentVersionRequest.Builder().apply(block).build())

    /**
     * Retrieves the metadata of the specified folder.
     */
    suspend fun getFolder(input: GetFolderRequest): GetFolderResponse

    /**
     * Retrieves the metadata of the specified folder.
     */
    suspend fun getFolder(block: GetFolderRequest.Builder.() -> Unit) = getFolder(GetFolderRequest.Builder().apply(block).build())

    /**
     * Retrieves the path information (the hierarchy from the root folder) for the
     * specified folder.
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the
     * requested folder and only includes the IDs of the parent folders in the path. You can
     * limit the maximum number of levels. You can also request the parent folder
     * names.
     */
    suspend fun getFolderPath(input: GetFolderPathRequest): GetFolderPathResponse

    /**
     * Retrieves the path information (the hierarchy from the root folder) for the
     * specified folder.
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the
     * requested folder and only includes the IDs of the parent folders in the path. You can
     * limit the maximum number of levels. You can also request the parent folder
     * names.
     */
    suspend fun getFolderPath(block: GetFolderPathRequest.Builder.() -> Unit) = getFolderPath(GetFolderPathRequest.Builder().apply(block).build())

    /**
     * Retrieves a collection of resources, including folders and documents. The only
     * CollectionType supported is SHARED_WITH_ME.
     */
    suspend fun getResources(input: GetResourcesRequest): GetResourcesResponse

    /**
     * Retrieves a collection of resources, including folders and documents. The only
     * CollectionType supported is SHARED_WITH_ME.
     */
    suspend fun getResources(block: GetResourcesRequest.Builder.() -> Unit) = getResources(GetResourcesRequest.Builder().apply(block).build())

    /**
     * Creates a new document object and version object.
     * The client specifies the parent folder ID and name of the document to upload. The
     * ID is optionally specified when creating a new version of an existing document. This is
     * the first step to upload a document. Next, upload the document to the URL returned from
     * the call, and then call UpdateDocumentVersion.
     * To cancel the document upload, call AbortDocumentVersionUpload.
     */
    suspend fun initiateDocumentVersionUpload(input: InitiateDocumentVersionUploadRequest): InitiateDocumentVersionUploadResponse

    /**
     * Creates a new document object and version object.
     * The client specifies the parent folder ID and name of the document to upload. The
     * ID is optionally specified when creating a new version of an existing document. This is
     * the first step to upload a document. Next, upload the document to the URL returned from
     * the call, and then call UpdateDocumentVersion.
     * To cancel the document upload, call AbortDocumentVersionUpload.
     */
    suspend fun initiateDocumentVersionUpload(block: InitiateDocumentVersionUploadRequest.Builder.() -> Unit) = initiateDocumentVersionUpload(InitiateDocumentVersionUploadRequest.Builder().apply(block).build())

    /**
     * Removes all the permissions from the specified resource.
     */
    suspend fun removeAllResourcePermissions(input: RemoveAllResourcePermissionsRequest): RemoveAllResourcePermissionsResponse

    /**
     * Removes all the permissions from the specified resource.
     */
    suspend fun removeAllResourcePermissions(block: RemoveAllResourcePermissionsRequest.Builder.() -> Unit) = removeAllResourcePermissions(RemoveAllResourcePermissionsRequest.Builder().apply(block).build())

    /**
     * Removes the permission for the specified principal from the specified
     * resource.
     */
    suspend fun removeResourcePermission(input: RemoveResourcePermissionRequest): RemoveResourcePermissionResponse

    /**
     * Removes the permission for the specified principal from the specified
     * resource.
     */
    suspend fun removeResourcePermission(block: RemoveResourcePermissionRequest.Builder.() -> Unit) = removeResourcePermission(RemoveResourcePermissionRequest.Builder().apply(block).build())

    /**
     * Updates the specified attributes of a document. The user must have access to both
     * the document and its parent folder, if applicable.
     */
    suspend fun updateDocument(input: UpdateDocumentRequest): UpdateDocumentResponse

    /**
     * Updates the specified attributes of a document. The user must have access to both
     * the document and its parent folder, if applicable.
     */
    suspend fun updateDocument(block: UpdateDocumentRequest.Builder.() -> Unit) = updateDocument(UpdateDocumentRequest.Builder().apply(block).build())

    /**
     * Changes the status of the document version to ACTIVE.
     * Amazon WorkDocs also sets its document container to ACTIVE. This is the last step
     * in a document upload, after the client uploads the document to an S3-presigned URL
     * returned by InitiateDocumentVersionUpload.
     */
    suspend fun updateDocumentVersion(input: UpdateDocumentVersionRequest): UpdateDocumentVersionResponse

    /**
     * Changes the status of the document version to ACTIVE.
     * Amazon WorkDocs also sets its document container to ACTIVE. This is the last step
     * in a document upload, after the client uploads the document to an S3-presigned URL
     * returned by InitiateDocumentVersionUpload.
     */
    suspend fun updateDocumentVersion(block: UpdateDocumentVersionRequest.Builder.() -> Unit) = updateDocumentVersion(UpdateDocumentVersionRequest.Builder().apply(block).build())

    /**
     * Updates the specified attributes of the specified folder. The user must have access
     * to both the folder and its parent folder, if applicable.
     */
    suspend fun updateFolder(input: UpdateFolderRequest): UpdateFolderResponse

    /**
     * Updates the specified attributes of the specified folder. The user must have access
     * to both the folder and its parent folder, if applicable.
     */
    suspend fun updateFolder(block: UpdateFolderRequest.Builder.() -> Unit) = updateFolder(UpdateFolderRequest.Builder().apply(block).build())

    /**
     * Updates the specified attributes of the specified user, and grants or revokes
     * administrative privileges to the Amazon WorkDocs site.
     */
    suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse

    /**
     * Updates the specified attributes of the specified user, and grants or revokes
     * administrative privileges to the Amazon WorkDocs site.
     */
    suspend fun updateUser(block: UpdateUserRequest.Builder.() -> Unit) = updateUser(UpdateUserRequest.Builder().apply(block).build())
}
