// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.model



class CreateCommentRequest private constructor(builder: Builder) {
    /**
     * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
     */
    val authenticationToken: kotlin.String? = builder.authenticationToken
    /**
     * The ID of the document.
     */
    val documentId: kotlin.String? = builder.documentId
    /**
     * Set this parameter to TRUE to send an email out to the document collaborators after
     * the comment is created.
     */
    val notifyCollaborators: kotlin.Boolean = builder.notifyCollaborators
    /**
     * The ID of the parent comment.
     */
    val parentId: kotlin.String? = builder.parentId
    /**
     * The text of the comment.
     */
    val text: kotlin.String? = builder.text
    /**
     * The ID of the root comment in the thread.
     */
    val threadId: kotlin.String? = builder.threadId
    /**
     * The ID of the document version.
     */
    val versionId: kotlin.String? = builder.versionId
    /**
     * The visibility of the comment. Options are either PRIVATE, where the comment is
     * visible only to the comment author and document owner and co-owners, or PUBLIC, where
     * the comment is visible to document owners, co-owners, and contributors.
     */
    val visibility: aws.sdk.kotlin.services.workdocs.model.CommentVisibilityType? = builder.visibility

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workdocs.model.CreateCommentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCommentRequest(")
        append("authenticationToken=*** Sensitive Data Redacted ***,")
        append("documentId=$documentId,")
        append("notifyCollaborators=$notifyCollaborators,")
        append("parentId=$parentId,")
        append("text=*** Sensitive Data Redacted ***,")
        append("threadId=$threadId,")
        append("versionId=$versionId,")
        append("visibility=$visibility)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationToken?.hashCode() ?: 0
        result = 31 * result + (documentId?.hashCode() ?: 0)
        result = 31 * result + (notifyCollaborators.hashCode())
        result = 31 * result + (parentId?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        result = 31 * result + (threadId?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        result = 31 * result + (visibility?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCommentRequest

        if (authenticationToken != other.authenticationToken) return false
        if (documentId != other.documentId) return false
        if (notifyCollaborators != other.notifyCollaborators) return false
        if (parentId != other.parentId) return false
        if (text != other.text) return false
        if (threadId != other.threadId) return false
        if (versionId != other.versionId) return false
        if (visibility != other.visibility) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workdocs.model.CreateCommentRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
         */
        var authenticationToken: kotlin.String? = null
        /**
         * The ID of the document.
         */
        var documentId: kotlin.String? = null
        /**
         * Set this parameter to TRUE to send an email out to the document collaborators after
         * the comment is created.
         */
        var notifyCollaborators: kotlin.Boolean = false
        /**
         * The ID of the parent comment.
         */
        var parentId: kotlin.String? = null
        /**
         * The text of the comment.
         */
        var text: kotlin.String? = null
        /**
         * The ID of the root comment in the thread.
         */
        var threadId: kotlin.String? = null
        /**
         * The ID of the document version.
         */
        var versionId: kotlin.String? = null
        /**
         * The visibility of the comment. Options are either PRIVATE, where the comment is
         * visible only to the comment author and document owner and co-owners, or PUBLIC, where
         * the comment is visible to document owners, co-owners, and contributors.
         */
        var visibility: aws.sdk.kotlin.services.workdocs.model.CommentVisibilityType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workdocs.model.CreateCommentRequest) : this() {
            this.authenticationToken = x.authenticationToken
            this.documentId = x.documentId
            this.notifyCollaborators = x.notifyCollaborators
            this.parentId = x.parentId
            this.text = x.text
            this.threadId = x.threadId
            this.versionId = x.versionId
            this.visibility = x.visibility
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workdocs.model.CreateCommentRequest = CreateCommentRequest(this)
    }
}
