// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.model



class DescribeGroupsRequest private constructor(builder: Builder) {
    /**
     * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
     */
    val authenticationToken: kotlin.String? = builder.authenticationToken
    /**
     * The maximum number of items to return with this call.
     */
    val limit: kotlin.Int? = builder.limit
    /**
     * The marker for the next set of results. (You received this marker from a previous
     * call.)
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The ID of the organization.
     */
    val organizationId: kotlin.String? = builder.organizationId
    /**
     * A query to describe groups by group name.
     */
    val searchQuery: kotlin.String? = builder.searchQuery

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workdocs.model.DescribeGroupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeGroupsRequest(")
        append("authenticationToken=*** Sensitive Data Redacted ***,")
        append("limit=$limit,")
        append("marker=$marker,")
        append("organizationId=$organizationId,")
        append("searchQuery=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationToken?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (organizationId?.hashCode() ?: 0)
        result = 31 * result + (searchQuery?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeGroupsRequest

        if (authenticationToken != other.authenticationToken) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false
        if (organizationId != other.organizationId) return false
        if (searchQuery != other.searchQuery) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workdocs.model.DescribeGroupsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
         */
        var authenticationToken: kotlin.String? = null
        /**
         * The maximum number of items to return with this call.
         */
        var limit: kotlin.Int? = null
        /**
         * The marker for the next set of results. (You received this marker from a previous
         * call.)
         */
        var marker: kotlin.String? = null
        /**
         * The ID of the organization.
         */
        var organizationId: kotlin.String? = null
        /**
         * A query to describe groups by group name.
         */
        var searchQuery: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workdocs.model.DescribeGroupsRequest) : this() {
            this.authenticationToken = x.authenticationToken
            this.limit = x.limit
            this.marker = x.marker
            this.organizationId = x.organizationId
            this.searchQuery = x.searchQuery
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workdocs.model.DescribeGroupsRequest = DescribeGroupsRequest(this)
    }
}
