// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a version of a document.
 */
class DocumentVersionMetadata private constructor(builder: Builder) {
    /**
     * The timestamp when the content of the document was originally created.
     */
    val contentCreatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.contentCreatedTimestamp
    /**
     * The timestamp when the content of the document was modified.
     */
    val contentModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.contentModifiedTimestamp
    /**
     * The content type of the document.
     */
    val contentType: kotlin.String? = builder.contentType
    /**
     * The timestamp when the document was first uploaded.
     */
    val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The ID of the creator.
     */
    val creatorId: kotlin.String? = builder.creatorId
    /**
     * The ID of the version.
     */
    val id: kotlin.String? = builder.id
    /**
     * The timestamp when the document was last uploaded.
     */
    val modifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedTimestamp
    /**
     * The name of the version.
     */
    val name: kotlin.String? = builder.name
    /**
     * The signature of the document.
     */
    val signature: kotlin.String? = builder.signature
    /**
     * The size of the document, in bytes.
     */
    val size: kotlin.Long? = builder.size
    /**
     * The source of the document.
     */
    val source: Map<String, String>? = builder.source
    /**
     * The status of the document.
     */
    val status: aws.sdk.kotlin.services.workdocs.model.DocumentStatusType? = builder.status
    /**
     * The thumbnail of the document.
     */
    val thumbnail: Map<String, String>? = builder.thumbnail

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workdocs.model.DocumentVersionMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentVersionMetadata(")
        append("contentCreatedTimestamp=$contentCreatedTimestamp,")
        append("contentModifiedTimestamp=$contentModifiedTimestamp,")
        append("contentType=$contentType,")
        append("createdTimestamp=$createdTimestamp,")
        append("creatorId=$creatorId,")
        append("id=$id,")
        append("modifiedTimestamp=$modifiedTimestamp,")
        append("name=$name,")
        append("signature=$signature,")
        append("size=$size,")
        append("source=$source,")
        append("status=$status,")
        append("thumbnail=$thumbnail)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentCreatedTimestamp?.hashCode() ?: 0
        result = 31 * result + (contentModifiedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (creatorId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (modifiedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (signature?.hashCode() ?: 0)
        result = 31 * result + (size?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (thumbnail?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentVersionMetadata

        if (contentCreatedTimestamp != other.contentCreatedTimestamp) return false
        if (contentModifiedTimestamp != other.contentModifiedTimestamp) return false
        if (contentType != other.contentType) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (creatorId != other.creatorId) return false
        if (id != other.id) return false
        if (modifiedTimestamp != other.modifiedTimestamp) return false
        if (name != other.name) return false
        if (signature != other.signature) return false
        if (size != other.size) return false
        if (source != other.source) return false
        if (status != other.status) return false
        if (thumbnail != other.thumbnail) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workdocs.model.DocumentVersionMetadata = Builder(this).apply(block).build()

    class Builder {
        /**
         * The timestamp when the content of the document was originally created.
         */
        var contentCreatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp when the content of the document was modified.
         */
        var contentModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The content type of the document.
         */
        var contentType: kotlin.String? = null
        /**
         * The timestamp when the document was first uploaded.
         */
        var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the creator.
         */
        var creatorId: kotlin.String? = null
        /**
         * The ID of the version.
         */
        var id: kotlin.String? = null
        /**
         * The timestamp when the document was last uploaded.
         */
        var modifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the version.
         */
        var name: kotlin.String? = null
        /**
         * The signature of the document.
         */
        var signature: kotlin.String? = null
        /**
         * The size of the document, in bytes.
         */
        var size: kotlin.Long? = null
        /**
         * The source of the document.
         */
        var source: Map<String, String>? = null
        /**
         * The status of the document.
         */
        var status: aws.sdk.kotlin.services.workdocs.model.DocumentStatusType? = null
        /**
         * The thumbnail of the document.
         */
        var thumbnail: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workdocs.model.DocumentVersionMetadata) : this() {
            this.contentCreatedTimestamp = x.contentCreatedTimestamp
            this.contentModifiedTimestamp = x.contentModifiedTimestamp
            this.contentType = x.contentType
            this.createdTimestamp = x.createdTimestamp
            this.creatorId = x.creatorId
            this.id = x.id
            this.modifiedTimestamp = x.modifiedTimestamp
            this.name = x.name
            this.signature = x.signature
            this.size = x.size
            this.source = x.source
            this.status = x.status
            this.thumbnail = x.thumbnail
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workdocs.model.DocumentVersionMetadata = DocumentVersionMetadata(this)
    }
}
