// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workdocs.model.DeleteCustomMetadataResponse
import aws.sdk.kotlin.services.workdocs.model.WorkDocsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteCustomMetadataOperationDeserializer: HttpDeserialize<DeleteCustomMetadataResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteCustomMetadataResponse {
        if (!response.status.isSuccess()) {
            throwDeleteCustomMetadataError(context, response)
        }
        val builder = DeleteCustomMetadataResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteCustomMetadataError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkDocsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "EntityNotExistsException" -> EntityNotExistsExceptionDeserializer()
        "FailedDependencyException" -> FailedDependencyExceptionDeserializer()
        "ProhibitedStateException" -> ProhibitedStateExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer()
        "UnauthorizedResourceAccessException" -> UnauthorizedResourceAccessExceptionDeserializer()
        else -> throw WorkDocsException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
