// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workdocs.model.DescribeUsersResponse
import aws.sdk.kotlin.services.workdocs.model.User
import aws.sdk.kotlin.services.workdocs.model.WorkDocsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeUsersOperationDeserializer: HttpDeserialize<DescribeUsersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeUsersResponse {
        if (!response.status.isSuccess()) {
            throwDescribeUsersError(context, response)
        }
        val builder = DescribeUsersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeUsersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeUsersOperationBody(builder: DescribeUsersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Marker"))
    val TOTALNUMBEROFUSERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("TotalNumberOfUsers"))
    val USERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Users"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MARKER_DESCRIPTOR)
        field(TOTALNUMBEROFUSERS_DESCRIPTOR)
        field(USERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                TOTALNUMBEROFUSERS_DESCRIPTOR.index -> builder.totalNumberOfUsers = deserializeLong()
                USERS_DESCRIPTOR.index -> builder.users =
                    deserializer.deserializeList(USERS_DESCRIPTOR) {
                        val col0 = mutableListOf<User>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUserDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeUsersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkDocsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "EntityNotExistsException" -> EntityNotExistsExceptionDeserializer()
        "FailedDependencyException" -> FailedDependencyExceptionDeserializer()
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer()
        "RequestedEntityTooLargeException" -> RequestedEntityTooLargeExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer()
        "UnauthorizedResourceAccessException" -> UnauthorizedResourceAccessExceptionDeserializer()
        else -> throw WorkDocsException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
