// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workdocs.model.FolderMetadata
import aws.sdk.kotlin.services.workdocs.model.GetFolderResponse
import aws.sdk.kotlin.services.workdocs.model.WorkDocsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetFolderOperationDeserializer: HttpDeserialize<GetFolderResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetFolderResponse {
        if (!response.status.isSuccess()) {
            throwGetFolderError(context, response)
        }
        val builder = GetFolderResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetFolderOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeGetFolderOperationBody(builder: GetFolderResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("CustomMetadata"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Metadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMMETADATA_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMMETADATA_DESCRIPTOR.index -> builder.customMetadata =
                    deserializer.deserializeMap(CUSTOMMETADATA_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                METADATA_DESCRIPTOR.index -> builder.metadata = deserializeFolderMetadataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetFolderError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkDocsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "EntityNotExistsException" -> EntityNotExistsExceptionDeserializer()
        "FailedDependencyException" -> FailedDependencyExceptionDeserializer()
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer()
        "ProhibitedStateException" -> ProhibitedStateExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer()
        "UnauthorizedResourceAccessException" -> UnauthorizedResourceAccessExceptionDeserializer()
        else -> throw WorkDocsException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
