// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workdocs.model.DocumentMetadata
import aws.sdk.kotlin.services.workdocs.model.InitiateDocumentVersionUploadResponse
import aws.sdk.kotlin.services.workdocs.model.UploadMetadata
import aws.sdk.kotlin.services.workdocs.model.WorkDocsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class InitiateDocumentVersionUploadOperationDeserializer: HttpDeserialize<InitiateDocumentVersionUploadResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): InitiateDocumentVersionUploadResponse {
        if (!response.status.isSuccess()) {
            throwInitiateDocumentVersionUploadError(context, response)
        }
        val builder = InitiateDocumentVersionUploadResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeInitiateDocumentVersionUploadOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeInitiateDocumentVersionUploadOperationBody(builder: InitiateDocumentVersionUploadResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Metadata"))
    val UPLOADMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UploadMetadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(METADATA_DESCRIPTOR)
        field(UPLOADMETADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                METADATA_DESCRIPTOR.index -> builder.metadata = deserializeDocumentMetadataDocument(deserializer)
                UPLOADMETADATA_DESCRIPTOR.index -> builder.uploadMetadata = deserializeUploadMetadataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwInitiateDocumentVersionUploadError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkDocsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "DraftUploadOutOfSyncException" -> DraftUploadOutOfSyncExceptionDeserializer()
        "EntityAlreadyExistsException" -> EntityAlreadyExistsExceptionDeserializer()
        "EntityNotExistsException" -> EntityNotExistsExceptionDeserializer()
        "FailedDependencyException" -> FailedDependencyExceptionDeserializer()
        "ProhibitedStateException" -> ProhibitedStateExceptionDeserializer()
        "ResourceAlreadyCheckedOutException" -> ResourceAlreadyCheckedOutExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "StorageLimitExceededException" -> StorageLimitExceededExceptionDeserializer()
        "StorageLimitWillExceedException" -> StorageLimitWillExceedExceptionDeserializer()
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer()
        "UnauthorizedResourceAccessException" -> UnauthorizedResourceAccessExceptionDeserializer()
        else -> throw WorkDocsException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
