// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workdocs.model.UpdateDocumentResponse
import aws.sdk.kotlin.services.workdocs.model.WorkDocsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class UpdateDocumentOperationDeserializer: HttpDeserialize<UpdateDocumentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateDocumentResponse {
        if (!response.status.isSuccess()) {
            throwUpdateDocumentError(context, response)
        }
        val builder = UpdateDocumentResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwUpdateDocumentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkDocsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer()
        "ConflictingOperationException" -> ConflictingOperationExceptionDeserializer()
        "EntityAlreadyExistsException" -> EntityAlreadyExistsExceptionDeserializer()
        "EntityNotExistsException" -> EntityNotExistsExceptionDeserializer()
        "FailedDependencyException" -> FailedDependencyExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "ProhibitedStateException" -> ProhibitedStateExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer()
        "UnauthorizedResourceAccessException" -> UnauthorizedResourceAccessExceptionDeserializer()
        else -> throw WorkDocsException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
