// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.transform

import aws.sdk.kotlin.services.workdocs.model.BooleanEnumType
import aws.sdk.kotlin.services.workdocs.model.LocaleType
import aws.sdk.kotlin.services.workdocs.model.StorageRuleType
import aws.sdk.kotlin.services.workdocs.model.UpdateUserRequest
import aws.sdk.kotlin.services.workdocs.model.UserType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateUserOperationSerializer: HttpSerialize<UpdateUserRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateUserRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf(
                "api",
                "v1",
                "users",
                "${input.userId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        builder.headers {
            if (input.authenticationToken?.isNotEmpty() == true) append("Authentication", input.authenticationToken)
        }

        val payload = serializeUpdateUserOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeUpdateUserOperationBody(context: ExecutionContext, input: UpdateUserRequest): ByteArray {
    val serializer = JsonSerializer()
    val GIVENNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GivenName"))
    val GRANTPOWERUSERPRIVILEGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GrantPoweruserPrivileges"))
    val LOCALE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Locale"))
    val STORAGERULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StorageRule"))
    val SURNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Surname"))
    val TIMEZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TimeZoneId"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(GIVENNAME_DESCRIPTOR)
        field(GRANTPOWERUSERPRIVILEGES_DESCRIPTOR)
        field(LOCALE_DESCRIPTOR)
        field(STORAGERULE_DESCRIPTOR)
        field(SURNAME_DESCRIPTOR)
        field(TIMEZONEID_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.givenName?.let { field(GIVENNAME_DESCRIPTOR, it) }
        input.grantPoweruserPrivileges?.let { field(GRANTPOWERUSERPRIVILEGES_DESCRIPTOR, it.value) }
        input.locale?.let { field(LOCALE_DESCRIPTOR, it.value) }
        input.storageRule?.let { field(STORAGERULE_DESCRIPTOR, it, ::serializeStorageRuleTypeDocument) }
        input.surname?.let { field(SURNAME_DESCRIPTOR, it) }
        input.timeZoneId?.let { field(TIMEZONEID_DESCRIPTOR, it) }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
