// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.worklink

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.worklink.model.*
import aws.sdk.kotlin.services.worklink.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "WorkLink"
const val ServiceApiVersion: String = "2018-09-25"
const val SdkVersion: String = "0.16.4-beta"

internal class DefaultWorkLinkClient(override val config: WorkLinkClient.Config) : WorkLinkClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Specifies a domain to be associated to Amazon WorkLink.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun associateDomain(input: AssociateDomainRequest): AssociateDomainResponse {
        val op = SdkHttpOperation.build<AssociateDomainRequest, AssociateDomainResponse> {
            serializer = AssociateDomainOperationSerializer()
            deserializer = AssociateDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a website authorization provider with a specified fleet. This is used to authorize users against associated websites in the company network.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun associateWebsiteAuthorizationProvider(input: AssociateWebsiteAuthorizationProviderRequest): AssociateWebsiteAuthorizationProviderResponse {
        val op = SdkHttpOperation.build<AssociateWebsiteAuthorizationProviderRequest, AssociateWebsiteAuthorizationProviderResponse> {
            serializer = AssociateWebsiteAuthorizationProviderOperationSerializer()
            deserializer = AssociateWebsiteAuthorizationProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateWebsiteAuthorizationProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Imports the root certificate of a certificate authority (CA) used to obtain TLS certificates used by associated websites within the company network.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun associateWebsiteCertificateAuthority(input: AssociateWebsiteCertificateAuthorityRequest): AssociateWebsiteCertificateAuthorityResponse {
        val op = SdkHttpOperation.build<AssociateWebsiteCertificateAuthorityRequest, AssociateWebsiteCertificateAuthorityResponse> {
            serializer = AssociateWebsiteCertificateAuthorityOperationSerializer()
            deserializer = AssociateWebsiteCertificateAuthorityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateWebsiteCertificateAuthority"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a fleet. A fleet consists of resources and the configuration that delivers associated websites to authorized users who download and set up the Amazon WorkLink app.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse {
        val op = SdkHttpOperation.build<CreateFleetRequest, CreateFleetResponse> {
            serializer = CreateFleetOperationSerializer()
            deserializer = CreateFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a fleet. Prevents users from accessing previously associated websites.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteFleet(input: DeleteFleetRequest): DeleteFleetResponse {
        val op = SdkHttpOperation.build<DeleteFleetRequest, DeleteFleetResponse> {
            serializer = DeleteFleetOperationSerializer()
            deserializer = DeleteFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the configuration for delivering audit streams to the customer account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeAuditStreamConfiguration(input: DescribeAuditStreamConfigurationRequest): DescribeAuditStreamConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeAuditStreamConfigurationRequest, DescribeAuditStreamConfigurationResponse> {
            serializer = DescribeAuditStreamConfigurationOperationSerializer()
            deserializer = DescribeAuditStreamConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAuditStreamConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the networking configuration to access the internal websites associated with the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeCompanyNetworkConfiguration(input: DescribeCompanyNetworkConfigurationRequest): DescribeCompanyNetworkConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeCompanyNetworkConfigurationRequest, DescribeCompanyNetworkConfigurationResponse> {
            serializer = DescribeCompanyNetworkConfigurationOperationSerializer()
            deserializer = DescribeCompanyNetworkConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCompanyNetworkConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about a user's device.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeDevice(input: DescribeDeviceRequest): DescribeDeviceResponse {
        val op = SdkHttpOperation.build<DescribeDeviceRequest, DescribeDeviceResponse> {
            serializer = DescribeDeviceOperationSerializer()
            deserializer = DescribeDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the device policy configuration for the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeDevicePolicyConfiguration(input: DescribeDevicePolicyConfigurationRequest): DescribeDevicePolicyConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeDevicePolicyConfigurationRequest, DescribeDevicePolicyConfigurationResponse> {
            serializer = DescribeDevicePolicyConfigurationOperationSerializer()
            deserializer = DescribeDevicePolicyConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDevicePolicyConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the domain.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse {
        val op = SdkHttpOperation.build<DescribeDomainRequest, DescribeDomainResponse> {
            serializer = DescribeDomainOperationSerializer()
            deserializer = DescribeDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides basic information for the specified fleet, excluding identity provider, networking, and device configuration details.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeFleetMetadata(input: DescribeFleetMetadataRequest): DescribeFleetMetadataResponse {
        val op = SdkHttpOperation.build<DescribeFleetMetadataRequest, DescribeFleetMetadataResponse> {
            serializer = DescribeFleetMetadataOperationSerializer()
            deserializer = DescribeFleetMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFleetMetadata"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the identity provider configuration of the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeIdentityProviderConfiguration(input: DescribeIdentityProviderConfigurationRequest): DescribeIdentityProviderConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeIdentityProviderConfigurationRequest, DescribeIdentityProviderConfigurationResponse> {
            serializer = DescribeIdentityProviderConfigurationOperationSerializer()
            deserializer = DescribeIdentityProviderConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIdentityProviderConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the certificate authority.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeWebsiteCertificateAuthority(input: DescribeWebsiteCertificateAuthorityRequest): DescribeWebsiteCertificateAuthorityResponse {
        val op = SdkHttpOperation.build<DescribeWebsiteCertificateAuthorityRequest, DescribeWebsiteCertificateAuthorityResponse> {
            serializer = DescribeWebsiteCertificateAuthorityOperationSerializer()
            deserializer = DescribeWebsiteCertificateAuthorityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWebsiteCertificateAuthority"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a domain from Amazon WorkLink. End users lose the ability to access the domain with Amazon WorkLink.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun disassociateDomain(input: DisassociateDomainRequest): DisassociateDomainResponse {
        val op = SdkHttpOperation.build<DisassociateDomainRequest, DisassociateDomainResponse> {
            serializer = DisassociateDomainOperationSerializer()
            deserializer = DisassociateDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a website authorization provider from a specified fleet. After the disassociation, users can't load any associated websites that require this authorization provider.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun disassociateWebsiteAuthorizationProvider(input: DisassociateWebsiteAuthorizationProviderRequest): DisassociateWebsiteAuthorizationProviderResponse {
        val op = SdkHttpOperation.build<DisassociateWebsiteAuthorizationProviderRequest, DisassociateWebsiteAuthorizationProviderResponse> {
            serializer = DisassociateWebsiteAuthorizationProviderOperationSerializer()
            deserializer = DisassociateWebsiteAuthorizationProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateWebsiteAuthorizationProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a certificate authority (CA).
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun disassociateWebsiteCertificateAuthority(input: DisassociateWebsiteCertificateAuthorityRequest): DisassociateWebsiteCertificateAuthorityResponse {
        val op = SdkHttpOperation.build<DisassociateWebsiteCertificateAuthorityRequest, DisassociateWebsiteCertificateAuthorityResponse> {
            serializer = DisassociateWebsiteCertificateAuthorityOperationSerializer()
            deserializer = DisassociateWebsiteCertificateAuthorityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateWebsiteCertificateAuthority"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of devices registered with the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listDevices(input: ListDevicesRequest): ListDevicesResponse {
        val op = SdkHttpOperation.build<ListDevicesRequest, ListDevicesResponse> {
            serializer = ListDevicesOperationSerializer()
            deserializer = ListDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDevices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of domains associated to a specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listDomains(input: ListDomainsRequest): ListDomainsResponse {
        val op = SdkHttpOperation.build<ListDomainsRequest, ListDomainsResponse> {
            serializer = ListDomainsOperationSerializer()
            deserializer = ListDomainsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomains"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of fleets for the current account and Region.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listFleets(input: ListFleetsRequest): ListFleetsResponse {
        val op = SdkHttpOperation.build<ListFleetsRequest, ListFleetsResponse> {
            serializer = ListFleetsOperationSerializer()
            deserializer = ListFleetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFleets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of tags for the specified resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of website authorization providers associated with a specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listWebsiteAuthorizationProviders(input: ListWebsiteAuthorizationProvidersRequest): ListWebsiteAuthorizationProvidersResponse {
        val op = SdkHttpOperation.build<ListWebsiteAuthorizationProvidersRequest, ListWebsiteAuthorizationProvidersResponse> {
            serializer = ListWebsiteAuthorizationProvidersOperationSerializer()
            deserializer = ListWebsiteAuthorizationProvidersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWebsiteAuthorizationProviders"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of certificate authorities added for the current account and Region.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listWebsiteCertificateAuthorities(input: ListWebsiteCertificateAuthoritiesRequest): ListWebsiteCertificateAuthoritiesResponse {
        val op = SdkHttpOperation.build<ListWebsiteCertificateAuthoritiesRequest, ListWebsiteCertificateAuthoritiesResponse> {
            serializer = ListWebsiteCertificateAuthoritiesOperationSerializer()
            deserializer = ListWebsiteCertificateAuthoritiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWebsiteCertificateAuthorities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Moves a domain to ACTIVE status if it was in the INACTIVE status.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun restoreDomainAccess(input: RestoreDomainAccessRequest): RestoreDomainAccessResponse {
        val op = SdkHttpOperation.build<RestoreDomainAccessRequest, RestoreDomainAccessResponse> {
            serializer = RestoreDomainAccessOperationSerializer()
            deserializer = RestoreDomainAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreDomainAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Moves a domain to INACTIVE status if it was in the ACTIVE status.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun revokeDomainAccess(input: RevokeDomainAccessRequest): RevokeDomainAccessResponse {
        val op = SdkHttpOperation.build<RevokeDomainAccessRequest, RevokeDomainAccessResponse> {
            serializer = RevokeDomainAccessOperationSerializer()
            deserializer = RevokeDomainAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RevokeDomainAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Signs the user out from all of their devices. The user can sign in again if they have valid credentials.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun signOutUser(input: SignOutUserRequest): SignOutUserResponse {
        val op = SdkHttpOperation.build<SignOutUserRequest, SignOutUserResponse> {
            serializer = SignOutUserOperationSerializer()
            deserializer = SignOutUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SignOutUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or overwrites one or more tags for the specified resource, such as a fleet. Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this operation updates its value.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from the specified resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the audit stream configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateAuditStreamConfiguration(input: UpdateAuditStreamConfigurationRequest): UpdateAuditStreamConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateAuditStreamConfigurationRequest, UpdateAuditStreamConfigurationResponse> {
            serializer = UpdateAuditStreamConfigurationOperationSerializer()
            deserializer = UpdateAuditStreamConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAuditStreamConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the company network configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateCompanyNetworkConfiguration(input: UpdateCompanyNetworkConfigurationRequest): UpdateCompanyNetworkConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateCompanyNetworkConfigurationRequest, UpdateCompanyNetworkConfigurationResponse> {
            serializer = UpdateCompanyNetworkConfigurationOperationSerializer()
            deserializer = UpdateCompanyNetworkConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCompanyNetworkConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the device policy configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateDevicePolicyConfiguration(input: UpdateDevicePolicyConfigurationRequest): UpdateDevicePolicyConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateDevicePolicyConfigurationRequest, UpdateDevicePolicyConfigurationResponse> {
            serializer = UpdateDevicePolicyConfigurationOperationSerializer()
            deserializer = UpdateDevicePolicyConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDevicePolicyConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates domain metadata, such as DisplayName.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateDomainMetadata(input: UpdateDomainMetadataRequest): UpdateDomainMetadataResponse {
        val op = SdkHttpOperation.build<UpdateDomainMetadataRequest, UpdateDomainMetadataResponse> {
            serializer = UpdateDomainMetadataOperationSerializer()
            deserializer = UpdateDomainMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDomainMetadata"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates fleet metadata, such as DisplayName.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateFleetMetadata(input: UpdateFleetMetadataRequest): UpdateFleetMetadataResponse {
        val op = SdkHttpOperation.build<UpdateFleetMetadataRequest, UpdateFleetMetadataResponse> {
            serializer = UpdateFleetMetadataOperationSerializer()
            deserializer = UpdateFleetMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFleetMetadata"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the identity provider configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateIdentityProviderConfiguration(input: UpdateIdentityProviderConfigurationRequest): UpdateIdentityProviderConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateIdentityProviderConfigurationRequest, UpdateIdentityProviderConfigurationResponse> {
            serializer = UpdateIdentityProviderConfigurationOperationSerializer()
            deserializer = UpdateIdentityProviderConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateIdentityProviderConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "worklink"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "worklink")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
