// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.worklink

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.worklink.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.worklink.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon WorkLink is a cloud-based service that provides secure access to internal websites and web apps from iOS and Android phones. In a single step, your users, such as employees, can access internal websites as efficiently as they access any other public website. They enter a URL in their web browser, or choose a link to an internal website in an email. Amazon WorkLink authenticates the user's access and securely renders authorized internal web content in a secure rendering service in the AWS cloud. Amazon WorkLink doesn't download or store any internal web content on mobile devices.
 */
interface WorkLinkClient : SdkClient {

    override val serviceName: String
        get() = "WorkLink"
    /**
     * WorkLinkClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): WorkLinkClient {
            val config = Config.Builder().apply(block).build()
            return DefaultWorkLinkClient(config)
        }

        operator fun invoke(config: Config): WorkLinkClient = DefaultWorkLinkClient(config)

        /**
         * Construct a [WorkLinkClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): WorkLinkClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultWorkLinkClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Specifies a domain to be associated to Amazon WorkLink.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun associateDomain(input: AssociateDomainRequest): AssociateDomainResponse

    /**
     * Specifies a domain to be associated to Amazon WorkLink.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun associateDomain(block: AssociateDomainRequest.Builder.() -> Unit) = associateDomain(AssociateDomainRequest.Builder().apply(block).build())

    /**
     * Associates a website authorization provider with a specified fleet. This is used to authorize users against associated websites in the company network.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun associateWebsiteAuthorizationProvider(input: AssociateWebsiteAuthorizationProviderRequest): AssociateWebsiteAuthorizationProviderResponse

    /**
     * Associates a website authorization provider with a specified fleet. This is used to authorize users against associated websites in the company network.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun associateWebsiteAuthorizationProvider(block: AssociateWebsiteAuthorizationProviderRequest.Builder.() -> Unit) = associateWebsiteAuthorizationProvider(AssociateWebsiteAuthorizationProviderRequest.Builder().apply(block).build())

    /**
     * Imports the root certificate of a certificate authority (CA) used to obtain TLS certificates used by associated websites within the company network.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun associateWebsiteCertificateAuthority(input: AssociateWebsiteCertificateAuthorityRequest): AssociateWebsiteCertificateAuthorityResponse

    /**
     * Imports the root certificate of a certificate authority (CA) used to obtain TLS certificates used by associated websites within the company network.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun associateWebsiteCertificateAuthority(block: AssociateWebsiteCertificateAuthorityRequest.Builder.() -> Unit) = associateWebsiteCertificateAuthority(AssociateWebsiteCertificateAuthorityRequest.Builder().apply(block).build())

    /**
     * Creates a fleet. A fleet consists of resources and the configuration that delivers associated websites to authorized users who download and set up the Amazon WorkLink app.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse

    /**
     * Creates a fleet. A fleet consists of resources and the configuration that delivers associated websites to authorized users who download and set up the Amazon WorkLink app.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun createFleet(block: CreateFleetRequest.Builder.() -> Unit) = createFleet(CreateFleetRequest.Builder().apply(block).build())

    /**
     * Deletes a fleet. Prevents users from accessing previously associated websites.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun deleteFleet(input: DeleteFleetRequest): DeleteFleetResponse

    /**
     * Deletes a fleet. Prevents users from accessing previously associated websites.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun deleteFleet(block: DeleteFleetRequest.Builder.() -> Unit) = deleteFleet(DeleteFleetRequest.Builder().apply(block).build())

    /**
     * Describes the configuration for delivering audit streams to the customer account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeAuditStreamConfiguration(input: DescribeAuditStreamConfigurationRequest): DescribeAuditStreamConfigurationResponse

    /**
     * Describes the configuration for delivering audit streams to the customer account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeAuditStreamConfiguration(block: DescribeAuditStreamConfigurationRequest.Builder.() -> Unit) = describeAuditStreamConfiguration(DescribeAuditStreamConfigurationRequest.Builder().apply(block).build())

    /**
     * Describes the networking configuration to access the internal websites associated with the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeCompanyNetworkConfiguration(input: DescribeCompanyNetworkConfigurationRequest): DescribeCompanyNetworkConfigurationResponse

    /**
     * Describes the networking configuration to access the internal websites associated with the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeCompanyNetworkConfiguration(block: DescribeCompanyNetworkConfigurationRequest.Builder.() -> Unit) = describeCompanyNetworkConfiguration(DescribeCompanyNetworkConfigurationRequest.Builder().apply(block).build())

    /**
     * Provides information about a user's device.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeDevice(input: DescribeDeviceRequest): DescribeDeviceResponse

    /**
     * Provides information about a user's device.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeDevice(block: DescribeDeviceRequest.Builder.() -> Unit) = describeDevice(DescribeDeviceRequest.Builder().apply(block).build())

    /**
     * Describes the device policy configuration for the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeDevicePolicyConfiguration(input: DescribeDevicePolicyConfigurationRequest): DescribeDevicePolicyConfigurationResponse

    /**
     * Describes the device policy configuration for the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeDevicePolicyConfiguration(block: DescribeDevicePolicyConfigurationRequest.Builder.() -> Unit) = describeDevicePolicyConfiguration(DescribeDevicePolicyConfigurationRequest.Builder().apply(block).build())

    /**
     * Provides information about the domain.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse

    /**
     * Provides information about the domain.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeDomain(block: DescribeDomainRequest.Builder.() -> Unit) = describeDomain(DescribeDomainRequest.Builder().apply(block).build())

    /**
     * Provides basic information for the specified fleet, excluding identity provider, networking, and device configuration details.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeFleetMetadata(input: DescribeFleetMetadataRequest): DescribeFleetMetadataResponse

    /**
     * Provides basic information for the specified fleet, excluding identity provider, networking, and device configuration details.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeFleetMetadata(block: DescribeFleetMetadataRequest.Builder.() -> Unit) = describeFleetMetadata(DescribeFleetMetadataRequest.Builder().apply(block).build())

    /**
     * Describes the identity provider configuration of the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeIdentityProviderConfiguration(input: DescribeIdentityProviderConfigurationRequest): DescribeIdentityProviderConfigurationResponse

    /**
     * Describes the identity provider configuration of the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeIdentityProviderConfiguration(block: DescribeIdentityProviderConfigurationRequest.Builder.() -> Unit) = describeIdentityProviderConfiguration(DescribeIdentityProviderConfigurationRequest.Builder().apply(block).build())

    /**
     * Provides information about the certificate authority.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeWebsiteCertificateAuthority(input: DescribeWebsiteCertificateAuthorityRequest): DescribeWebsiteCertificateAuthorityResponse

    /**
     * Provides information about the certificate authority.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeWebsiteCertificateAuthority(block: DescribeWebsiteCertificateAuthorityRequest.Builder.() -> Unit) = describeWebsiteCertificateAuthority(DescribeWebsiteCertificateAuthorityRequest.Builder().apply(block).build())

    /**
     * Disassociates a domain from Amazon WorkLink. End users lose the ability to access the domain with Amazon WorkLink.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun disassociateDomain(input: DisassociateDomainRequest): DisassociateDomainResponse

    /**
     * Disassociates a domain from Amazon WorkLink. End users lose the ability to access the domain with Amazon WorkLink.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun disassociateDomain(block: DisassociateDomainRequest.Builder.() -> Unit) = disassociateDomain(DisassociateDomainRequest.Builder().apply(block).build())

    /**
     * Disassociates a website authorization provider from a specified fleet. After the disassociation, users can't load any associated websites that require this authorization provider.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun disassociateWebsiteAuthorizationProvider(input: DisassociateWebsiteAuthorizationProviderRequest): DisassociateWebsiteAuthorizationProviderResponse

    /**
     * Disassociates a website authorization provider from a specified fleet. After the disassociation, users can't load any associated websites that require this authorization provider.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun disassociateWebsiteAuthorizationProvider(block: DisassociateWebsiteAuthorizationProviderRequest.Builder.() -> Unit) = disassociateWebsiteAuthorizationProvider(DisassociateWebsiteAuthorizationProviderRequest.Builder().apply(block).build())

    /**
     * Removes a certificate authority (CA).
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun disassociateWebsiteCertificateAuthority(input: DisassociateWebsiteCertificateAuthorityRequest): DisassociateWebsiteCertificateAuthorityResponse

    /**
     * Removes a certificate authority (CA).
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun disassociateWebsiteCertificateAuthority(block: DisassociateWebsiteCertificateAuthorityRequest.Builder.() -> Unit) = disassociateWebsiteCertificateAuthority(DisassociateWebsiteCertificateAuthorityRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of devices registered with the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listDevices(input: ListDevicesRequest): ListDevicesResponse

    /**
     * Retrieves a list of devices registered with the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listDevices(block: ListDevicesRequest.Builder.() -> Unit) = listDevices(ListDevicesRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of domains associated to a specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listDomains(input: ListDomainsRequest): ListDomainsResponse

    /**
     * Retrieves a list of domains associated to a specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listDomains(block: ListDomainsRequest.Builder.() -> Unit) = listDomains(ListDomainsRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of fleets for the current account and Region.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listFleets(input: ListFleetsRequest = ListFleetsRequest {}): ListFleetsResponse

    /**
     * Retrieves a list of fleets for the current account and Region.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listFleets(block: ListFleetsRequest.Builder.() -> Unit) = listFleets(ListFleetsRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of tags for the specified resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves a list of tags for the specified resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of website authorization providers associated with a specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listWebsiteAuthorizationProviders(input: ListWebsiteAuthorizationProvidersRequest): ListWebsiteAuthorizationProvidersResponse

    /**
     * Retrieves a list of website authorization providers associated with a specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listWebsiteAuthorizationProviders(block: ListWebsiteAuthorizationProvidersRequest.Builder.() -> Unit) = listWebsiteAuthorizationProviders(ListWebsiteAuthorizationProvidersRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of certificate authorities added for the current account and Region.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listWebsiteCertificateAuthorities(input: ListWebsiteCertificateAuthoritiesRequest): ListWebsiteCertificateAuthoritiesResponse

    /**
     * Retrieves a list of certificate authorities added for the current account and Region.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listWebsiteCertificateAuthorities(block: ListWebsiteCertificateAuthoritiesRequest.Builder.() -> Unit) = listWebsiteCertificateAuthorities(ListWebsiteCertificateAuthoritiesRequest.Builder().apply(block).build())

    /**
     * Moves a domain to ACTIVE status if it was in the INACTIVE status.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun restoreDomainAccess(input: RestoreDomainAccessRequest): RestoreDomainAccessResponse

    /**
     * Moves a domain to ACTIVE status if it was in the INACTIVE status.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun restoreDomainAccess(block: RestoreDomainAccessRequest.Builder.() -> Unit) = restoreDomainAccess(RestoreDomainAccessRequest.Builder().apply(block).build())

    /**
     * Moves a domain to INACTIVE status if it was in the ACTIVE status.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun revokeDomainAccess(input: RevokeDomainAccessRequest): RevokeDomainAccessResponse

    /**
     * Moves a domain to INACTIVE status if it was in the ACTIVE status.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun revokeDomainAccess(block: RevokeDomainAccessRequest.Builder.() -> Unit) = revokeDomainAccess(RevokeDomainAccessRequest.Builder().apply(block).build())

    /**
     * Signs the user out from all of their devices. The user can sign in again if they have valid credentials.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun signOutUser(input: SignOutUserRequest): SignOutUserResponse

    /**
     * Signs the user out from all of their devices. The user can sign in again if they have valid credentials.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun signOutUser(block: SignOutUserRequest.Builder.() -> Unit) = signOutUser(SignOutUserRequest.Builder().apply(block).build())

    /**
     * Adds or overwrites one or more tags for the specified resource, such as a fleet. Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this operation updates its value.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds or overwrites one or more tags for the specified resource, such as a fleet. Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this operation updates its value.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes one or more tags from the specified resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the audit stream configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun updateAuditStreamConfiguration(input: UpdateAuditStreamConfigurationRequest): UpdateAuditStreamConfigurationResponse

    /**
     * Updates the audit stream configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun updateAuditStreamConfiguration(block: UpdateAuditStreamConfigurationRequest.Builder.() -> Unit) = updateAuditStreamConfiguration(UpdateAuditStreamConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates the company network configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun updateCompanyNetworkConfiguration(input: UpdateCompanyNetworkConfigurationRequest): UpdateCompanyNetworkConfigurationResponse

    /**
     * Updates the company network configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun updateCompanyNetworkConfiguration(block: UpdateCompanyNetworkConfigurationRequest.Builder.() -> Unit) = updateCompanyNetworkConfiguration(UpdateCompanyNetworkConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates the device policy configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun updateDevicePolicyConfiguration(input: UpdateDevicePolicyConfigurationRequest): UpdateDevicePolicyConfigurationResponse

    /**
     * Updates the device policy configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun updateDevicePolicyConfiguration(block: UpdateDevicePolicyConfigurationRequest.Builder.() -> Unit) = updateDevicePolicyConfiguration(UpdateDevicePolicyConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates domain metadata, such as DisplayName.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun updateDomainMetadata(input: UpdateDomainMetadataRequest): UpdateDomainMetadataResponse

    /**
     * Updates domain metadata, such as DisplayName.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun updateDomainMetadata(block: UpdateDomainMetadataRequest.Builder.() -> Unit) = updateDomainMetadata(UpdateDomainMetadataRequest.Builder().apply(block).build())

    /**
     * Updates fleet metadata, such as DisplayName.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun updateFleetMetadata(input: UpdateFleetMetadataRequest): UpdateFleetMetadataResponse

    /**
     * Updates fleet metadata, such as DisplayName.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun updateFleetMetadata(block: UpdateFleetMetadataRequest.Builder.() -> Unit) = updateFleetMetadata(UpdateFleetMetadataRequest.Builder().apply(block).build())

    /**
     * Updates the identity provider configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun updateIdentityProviderConfiguration(input: UpdateIdentityProviderConfigurationRequest): UpdateIdentityProviderConfigurationResponse

    /**
     * Updates the identity provider configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun updateIdentityProviderConfiguration(block: UpdateIdentityProviderConfigurationRequest.Builder.() -> Unit) = updateIdentityProviderConfiguration(UpdateIdentityProviderConfigurationRequest.Builder().apply(block).build())
}
