// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.worklink.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The summary of the fleet.
 */
class FleetSummary private constructor(builder: Builder) {
    /**
     * The identifier used by users to sign into the Amazon WorkLink app.
     */
    val companyCode: kotlin.String? = builder.companyCode
    /**
     * The time when the fleet was created.
     */
    val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The name of the fleet to display.
     */
    val displayName: kotlin.String? = builder.displayName
    /**
     * The Amazon Resource Name (ARN) of the fleet.
     */
    val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * The name of the fleet.
     */
    val fleetName: kotlin.String? = builder.fleetName
    /**
     * The status of the fleet.
     */
    val fleetStatus: aws.sdk.kotlin.services.worklink.model.FleetStatus? = builder.fleetStatus
    /**
     * The time when the fleet was last updated.
     */
    val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The tags attached to the resource. A tag is a key-value pair.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.worklink.model.FleetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FleetSummary(")
        append("companyCode=$companyCode,")
        append("createdTime=$createdTime,")
        append("displayName=$displayName,")
        append("fleetArn=$fleetArn,")
        append("fleetName=$fleetName,")
        append("fleetStatus=$fleetStatus,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = companyCode?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (fleetArn?.hashCode() ?: 0)
        result = 31 * result + (fleetName?.hashCode() ?: 0)
        result = 31 * result + (fleetStatus?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FleetSummary

        if (companyCode != other.companyCode) return false
        if (createdTime != other.createdTime) return false
        if (displayName != other.displayName) return false
        if (fleetArn != other.fleetArn) return false
        if (fleetName != other.fleetName) return false
        if (fleetStatus != other.fleetStatus) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.worklink.model.FleetSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier used by users to sign into the Amazon WorkLink app.
         */
        var companyCode: kotlin.String? = null
        /**
         * The time when the fleet was created.
         */
        var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the fleet to display.
         */
        var displayName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the fleet.
         */
        var fleetArn: kotlin.String? = null
        /**
         * The name of the fleet.
         */
        var fleetName: kotlin.String? = null
        /**
         * The status of the fleet.
         */
        var fleetStatus: aws.sdk.kotlin.services.worklink.model.FleetStatus? = null
        /**
         * The time when the fleet was last updated.
         */
        var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The tags attached to the resource. A tag is a key-value pair.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.worklink.model.FleetSummary) : this() {
            this.companyCode = x.companyCode
            this.createdTime = x.createdTime
            this.displayName = x.displayName
            this.fleetArn = x.fleetArn
            this.fleetName = x.fleetName
            this.fleetStatus = x.fleetStatus
            this.lastUpdatedTime = x.lastUpdatedTime
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.worklink.model.FleetSummary = FleetSummary(this)
    }
}
