// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmailmessageflow.model



/**
 * Provides the MIME content of the updated email message as an S3 object. All MIME content must meet the following criteria:
 * + Each part of a multipart MIME message must be formatted properly.
 * + Attachments must be of a content type that Amazon SES supports. For more information, see [Unsupported Attachment Types](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types-appendix.html).
 * + If any of the MIME parts in a message contain content that is outside of the 7-bit ASCII character range, we recommend encoding that content.
 * + Per [RFC 5321](https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6), the maximum length of each line of text, including the <crlf>, must not exceed 1,000 characters.
 * + The message must contain all the required header fields. Check the returned error message for more information.
 * + The value of immutable headers must remain unchanged. Check the returned error message for more information.
 * + Certain unique headers can only appear once. Check the returned error message for more information.
 */
public class RawMessageContent private constructor(builder: Builder) {
    /**
     * The S3 reference of an email message.
     */
    public val s3Reference: aws.sdk.kotlin.services.workmailmessageflow.model.S3Reference? = builder.s3Reference

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workmailmessageflow.model.RawMessageContent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RawMessageContent(")
        append("s3Reference=$s3Reference)")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3Reference?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RawMessageContent

        if (s3Reference != other.s3Reference) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workmailmessageflow.model.RawMessageContent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The S3 reference of an email message.
         */
        public var s3Reference: aws.sdk.kotlin.services.workmailmessageflow.model.S3Reference? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workmailmessageflow.model.RawMessageContent) : this() {
            this.s3Reference = x.s3Reference
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workmailmessageflow.model.RawMessageContent = RawMessageContent(this)

        /**
         * construct an [aws.sdk.kotlin.services.workmailmessageflow.model.S3Reference] inside the given [block]
         */
        public fun s3Reference(block: aws.sdk.kotlin.services.workmailmessageflow.model.S3Reference.Builder.() -> kotlin.Unit) {
            this.s3Reference = aws.sdk.kotlin.services.workmailmessageflow.model.S3Reference.invoke(block)
        }
    }
}
