// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model



/**
 * Describes a connection alias. Connection aliases are used for cross-Region redirection. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
 */
public class ConnectionAlias private constructor(builder: Builder) {
    /**
     * The identifier of the connection alias.
     */
    public val aliasId: kotlin.String? = builder.aliasId
    /**
     * The association status of the connection alias.
     */
    public val associations: List<ConnectionAliasAssociation>? = builder.associations
    /**
     * The connection string specified for the connection alias. The connection string must be in the form of a fully qualified domain name (FQDN), such as `www.example.com`.
     */
    public val connectionString: kotlin.String? = builder.connectionString
    /**
     * The identifier of the Amazon Web Services account that owns the connection alias.
     */
    public val ownerAccountId: kotlin.String? = builder.ownerAccountId
    /**
     * The current state of the connection alias.
     */
    public val state: aws.sdk.kotlin.services.workspaces.model.ConnectionAliasState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.ConnectionAlias = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectionAlias(")
        append("aliasId=$aliasId,")
        append("associations=$associations,")
        append("connectionString=$connectionString,")
        append("ownerAccountId=$ownerAccountId,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliasId?.hashCode() ?: 0
        result = 31 * result + (associations?.hashCode() ?: 0)
        result = 31 * result + (connectionString?.hashCode() ?: 0)
        result = 31 * result + (ownerAccountId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectionAlias

        if (aliasId != other.aliasId) return false
        if (associations != other.associations) return false
        if (connectionString != other.connectionString) return false
        if (ownerAccountId != other.ownerAccountId) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.ConnectionAlias = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the connection alias.
         */
        public var aliasId: kotlin.String? = null
        /**
         * The association status of the connection alias.
         */
        public var associations: List<ConnectionAliasAssociation>? = null
        /**
         * The connection string specified for the connection alias. The connection string must be in the form of a fully qualified domain name (FQDN), such as `www.example.com`.
         */
        public var connectionString: kotlin.String? = null
        /**
         * The identifier of the Amazon Web Services account that owns the connection alias.
         */
        public var ownerAccountId: kotlin.String? = null
        /**
         * The current state of the connection alias.
         */
        public var state: aws.sdk.kotlin.services.workspaces.model.ConnectionAliasState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.ConnectionAlias) : this() {
            this.aliasId = x.aliasId
            this.associations = x.associations
            this.connectionString = x.connectionString
            this.ownerAccountId = x.ownerAccountId
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.ConnectionAlias = ConnectionAlias(this)
    }
}
