// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.paginators

import aws.sdk.kotlin.services.workspaces.WorkSpacesClient
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceBundlesRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceBundlesResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceDirectoriesRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceDirectoriesResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspacesRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspacesResponse
import aws.sdk.kotlin.services.workspaces.model.Workspace
import aws.sdk.kotlin.services.workspaces.model.WorkspaceBundle
import aws.sdk.kotlin.services.workspaces.model.WorkspaceDirectory
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeWorkspaceBundlesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeWorkspaceBundlesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeWorkspaceBundlesResponse]
 */
public fun WorkSpacesClient.describeWorkspaceBundlesPaginated(initialRequest: DescribeWorkspaceBundlesRequest): Flow<DescribeWorkspaceBundlesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeWorkspaceBundlesPaginated.describeWorkspaceBundles(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeWorkspaceBundlesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeWorkspaceBundlesResponse]
 */
public fun WorkSpacesClient.describeWorkspaceBundlesPaginated(block: DescribeWorkspaceBundlesRequest.Builder.() -> Unit): Flow<DescribeWorkspaceBundlesResponse> =
    describeWorkspaceBundlesPaginated(DescribeWorkspaceBundlesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeWorkspaceBundlesPaginated]
 * to access the nested member [WorkspaceBundle]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkspaceBundle]
 */
@JvmName("describeWorkspaceBundlesResponseWorkspaceBundle")
public fun Flow<DescribeWorkspaceBundlesResponse>.bundles(): Flow<WorkspaceBundle> =
    transform() { response ->
        response.bundles?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeWorkspaceDirectoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeWorkspaceDirectoriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeWorkspaceDirectoriesResponse]
 */
public fun WorkSpacesClient.describeWorkspaceDirectoriesPaginated(initialRequest: DescribeWorkspaceDirectoriesRequest): Flow<DescribeWorkspaceDirectoriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeWorkspaceDirectoriesPaginated.describeWorkspaceDirectories(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeWorkspaceDirectoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeWorkspaceDirectoriesResponse]
 */
public fun WorkSpacesClient.describeWorkspaceDirectoriesPaginated(block: DescribeWorkspaceDirectoriesRequest.Builder.() -> Unit): Flow<DescribeWorkspaceDirectoriesResponse> =
    describeWorkspaceDirectoriesPaginated(DescribeWorkspaceDirectoriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeWorkspaceDirectoriesPaginated]
 * to access the nested member [WorkspaceDirectory]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkspaceDirectory]
 */
@JvmName("describeWorkspaceDirectoriesResponseWorkspaceDirectory")
public fun Flow<DescribeWorkspaceDirectoriesResponse>.directories(): Flow<WorkspaceDirectory> =
    transform() { response ->
        response.directories?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeWorkspacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeWorkspacesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeWorkspacesResponse]
 */
public fun WorkSpacesClient.describeWorkspacesPaginated(initialRequest: DescribeWorkspacesRequest): Flow<DescribeWorkspacesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeWorkspacesPaginated.describeWorkspaces(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeWorkspacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeWorkspacesResponse]
 */
public fun WorkSpacesClient.describeWorkspacesPaginated(block: DescribeWorkspacesRequest.Builder.() -> Unit): Flow<DescribeWorkspacesResponse> =
    describeWorkspacesPaginated(DescribeWorkspacesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeWorkspacesPaginated]
 * to access the nested member [Workspace]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Workspace]
 */
@JvmName("describeWorkspacesResponseWorkspace")
public fun Flow<DescribeWorkspacesResponse>.workspaces(): Flow<Workspace> =
    transform() { response ->
        response.workspaces?.forEach {
            emit(it)
        }
    }
