// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspacesResponse
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.sdk.kotlin.services.workspaces.model.Workspace
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeWorkspacesOperationDeserializer: HttpDeserialize<DescribeWorkspacesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeWorkspacesResponse {
        if (!response.status.isSuccess()) {
            throwDescribeWorkspacesError(context, response)
        }
        val builder = DescribeWorkspacesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeWorkspacesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeWorkspacesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValuesException" -> InvalidParameterValuesExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceUnavailableException" -> ResourceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeWorkspacesOperationBody(builder: DescribeWorkspacesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val WORKSPACES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Workspaces"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(WORKSPACES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                WORKSPACES_DESCRIPTOR.index -> builder.workspaces =
                    deserializer.deserializeList(WORKSPACES_DESCRIPTOR) {
                        val col0 = mutableListOf<Workspace>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWorkspaceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
