// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model



/**
 * Describes the default properties that are used for creating WorkSpaces. For more information, see [Update Directory Details for Your WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html).
 */
public class WorkspaceCreationProperties private constructor(builder: Builder) {
    /**
     * The identifier of your custom security group.
     */
    public val customSecurityGroupId: kotlin.String? = builder.customSecurityGroupId
    /**
     * The default organizational unit (OU) for your WorkSpaces directories. This string must be the full Lightweight Directory Access Protocol (LDAP) distinguished name for the target domain and OU. It must be in the form `"OU=<i>value</i>,DC=<i>value</i>,DC=<i>value</i>"`, where *value* is any string of characters, and the number of domain components (DCs) is two or more. For example, `OU=WorkSpaces_machines,DC=machines,DC=example,DC=com`.
     *
     * + To avoid errors, certain characters in the distinguished name must be escaped. For more information, see [ Distinguished Names](https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names) in the Microsoft documentation.
     * + The API doesn't validate whether the OU exists.
     */
    public val defaultOu: kotlin.String? = builder.defaultOu
    /**
     * Indicates whether internet access is enabled for your WorkSpaces.
     */
    public val enableInternetAccess: kotlin.Boolean? = builder.enableInternetAccess
    /**
     * Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see [WorkSpace Maintenance](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html).
     */
    public val enableMaintenanceMode: kotlin.Boolean? = builder.enableMaintenanceMode
    /**
     * Indicates whether Amazon WorkDocs is enabled for your WorkSpaces.
     *
     * If WorkDocs is already enabled for a WorkSpaces directory and you disable it, new WorkSpaces launched in the directory will not have WorkDocs enabled. However, WorkDocs remains enabled for any existing WorkSpaces, unless you either disable users' access to WorkDocs or you delete the WorkDocs site. To disable users' access to WorkDocs, see [Disabling Users](https://docs.aws.amazon.com/workdocs/latest/adminguide/inactive-user.html) in the *Amazon WorkDocs Administration Guide*. To delete a WorkDocs site, see [Deleting a Site](https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html) in the *Amazon WorkDocs Administration Guide*.
     *
     * If you enable WorkDocs on a directory that already has existing WorkSpaces, the existing WorkSpaces and any new WorkSpaces that are launched in the directory will have WorkDocs enabled.
     */
    public val enableWorkDocs: kotlin.Boolean? = builder.enableWorkDocs
    /**
     * Indicates whether users are local administrators of their WorkSpaces.
     */
    public val userEnabledAsLocalAdministrator: kotlin.Boolean? = builder.userEnabledAsLocalAdministrator

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.WorkspaceCreationProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspaceCreationProperties(")
        append("customSecurityGroupId=$customSecurityGroupId,")
        append("defaultOu=$defaultOu,")
        append("enableInternetAccess=$enableInternetAccess,")
        append("enableMaintenanceMode=$enableMaintenanceMode,")
        append("enableWorkDocs=$enableWorkDocs,")
        append("userEnabledAsLocalAdministrator=$userEnabledAsLocalAdministrator)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customSecurityGroupId?.hashCode() ?: 0
        result = 31 * result + (defaultOu?.hashCode() ?: 0)
        result = 31 * result + (enableInternetAccess?.hashCode() ?: 0)
        result = 31 * result + (enableMaintenanceMode?.hashCode() ?: 0)
        result = 31 * result + (enableWorkDocs?.hashCode() ?: 0)
        result = 31 * result + (userEnabledAsLocalAdministrator?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspaceCreationProperties

        if (customSecurityGroupId != other.customSecurityGroupId) return false
        if (defaultOu != other.defaultOu) return false
        if (enableInternetAccess != other.enableInternetAccess) return false
        if (enableMaintenanceMode != other.enableMaintenanceMode) return false
        if (enableWorkDocs != other.enableWorkDocs) return false
        if (userEnabledAsLocalAdministrator != other.userEnabledAsLocalAdministrator) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.WorkspaceCreationProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of your custom security group.
         */
        public var customSecurityGroupId: kotlin.String? = null
        /**
         * The default organizational unit (OU) for your WorkSpaces directories. This string must be the full Lightweight Directory Access Protocol (LDAP) distinguished name for the target domain and OU. It must be in the form `"OU=<i>value</i>,DC=<i>value</i>,DC=<i>value</i>"`, where *value* is any string of characters, and the number of domain components (DCs) is two or more. For example, `OU=WorkSpaces_machines,DC=machines,DC=example,DC=com`.
         *
         * + To avoid errors, certain characters in the distinguished name must be escaped. For more information, see [ Distinguished Names](https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names) in the Microsoft documentation.
         * + The API doesn't validate whether the OU exists.
         */
        public var defaultOu: kotlin.String? = null
        /**
         * Indicates whether internet access is enabled for your WorkSpaces.
         */
        public var enableInternetAccess: kotlin.Boolean? = null
        /**
         * Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see [WorkSpace Maintenance](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html).
         */
        public var enableMaintenanceMode: kotlin.Boolean? = null
        /**
         * Indicates whether Amazon WorkDocs is enabled for your WorkSpaces.
         *
         * If WorkDocs is already enabled for a WorkSpaces directory and you disable it, new WorkSpaces launched in the directory will not have WorkDocs enabled. However, WorkDocs remains enabled for any existing WorkSpaces, unless you either disable users' access to WorkDocs or you delete the WorkDocs site. To disable users' access to WorkDocs, see [Disabling Users](https://docs.aws.amazon.com/workdocs/latest/adminguide/inactive-user.html) in the *Amazon WorkDocs Administration Guide*. To delete a WorkDocs site, see [Deleting a Site](https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html) in the *Amazon WorkDocs Administration Guide*.
         *
         * If you enable WorkDocs on a directory that already has existing WorkSpaces, the existing WorkSpaces and any new WorkSpaces that are launched in the directory will have WorkDocs enabled.
         */
        public var enableWorkDocs: kotlin.Boolean? = null
        /**
         * Indicates whether users are local administrators of their WorkSpaces.
         */
        public var userEnabledAsLocalAdministrator: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.WorkspaceCreationProperties) : this() {
            this.customSecurityGroupId = x.customSecurityGroupId
            this.defaultOu = x.defaultOu
            this.enableInternetAccess = x.enableInternetAccess
            this.enableMaintenanceMode = x.enableMaintenanceMode
            this.enableWorkDocs = x.enableWorkDocs
            this.userEnabledAsLocalAdministrator = x.userEnabledAsLocalAdministrator
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.WorkspaceCreationProperties = WorkspaceCreationProperties(this)
    }
}
