// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.workspacesweb.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.workspacesweb.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucketOptions

/**
 * WorkSpaces Web is a low cost, fully managed WorkSpace built specifically to facilitate
 * secure, web-based workloads. WorkSpaces Web makes it easy for customers to safely provide
 * their employees with access to internal websites and SaaS web applications without the
 * administrative burden of appliances or specialized client software. WorkSpaces Web provides
 * simple policy tools tailored for user interactions, while offloading common tasks like
 * capacity management, scaling, and maintaining browser images.
 */
interface WorkSpacesWebClient : SdkClient {

    override val serviceName: String
        get() = "WorkSpaces Web"
    /**
     * WorkSpacesWebClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): WorkSpacesWebClient {
            val config = Config.Builder().apply(block).build()
            return DefaultWorkSpacesWebClient(config)
        }

        operator fun invoke(config: Config): WorkSpacesWebClient = DefaultWorkSpacesWebClient(config)

        /**
         * Construct a [WorkSpacesWebClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): WorkSpacesWebClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultWorkSpacesWebClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a browser settings resource with a web portal.
     */
    suspend fun associateBrowserSettings(input: AssociateBrowserSettingsRequest): AssociateBrowserSettingsResponse

    /**
     * Associates a browser settings resource with a web portal.
     */
    suspend fun associateBrowserSettings(block: AssociateBrowserSettingsRequest.Builder.() -> Unit) = associateBrowserSettings(AssociateBrowserSettingsRequest.Builder().apply(block).build())

    /**
     * Associates a network settings resource with a web portal.
     */
    suspend fun associateNetworkSettings(input: AssociateNetworkSettingsRequest): AssociateNetworkSettingsResponse

    /**
     * Associates a network settings resource with a web portal.
     */
    suspend fun associateNetworkSettings(block: AssociateNetworkSettingsRequest.Builder.() -> Unit) = associateNetworkSettings(AssociateNetworkSettingsRequest.Builder().apply(block).build())

    /**
     * Associates a trust store with a web portal.
     */
    suspend fun associateTrustStore(input: AssociateTrustStoreRequest): AssociateTrustStoreResponse

    /**
     * Associates a trust store with a web portal.
     */
    suspend fun associateTrustStore(block: AssociateTrustStoreRequest.Builder.() -> Unit) = associateTrustStore(AssociateTrustStoreRequest.Builder().apply(block).build())

    /**
     * Associates a user settings resource with a web portal.
     */
    suspend fun associateUserSettings(input: AssociateUserSettingsRequest): AssociateUserSettingsResponse

    /**
     * Associates a user settings resource with a web portal.
     */
    suspend fun associateUserSettings(block: AssociateUserSettingsRequest.Builder.() -> Unit) = associateUserSettings(AssociateUserSettingsRequest.Builder().apply(block).build())

    /**
     * Creates a browser settings resource that can be associated with a web portal. Once
     * associated with a web portal, browser settings control how the browser will behave once a
     * user starts a streaming session for the web portal.
     */
    suspend fun createBrowserSettings(input: CreateBrowserSettingsRequest): CreateBrowserSettingsResponse

    /**
     * Creates a browser settings resource that can be associated with a web portal. Once
     * associated with a web portal, browser settings control how the browser will behave once a
     * user starts a streaming session for the web portal.
     */
    suspend fun createBrowserSettings(block: CreateBrowserSettingsRequest.Builder.() -> Unit) = createBrowserSettings(CreateBrowserSettingsRequest.Builder().apply(block).build())

    /**
     * Creates an identity provider resource that is then associated with a web portal.
     */
    suspend fun createIdentityProvider(input: CreateIdentityProviderRequest): CreateIdentityProviderResponse

    /**
     * Creates an identity provider resource that is then associated with a web portal.
     */
    suspend fun createIdentityProvider(block: CreateIdentityProviderRequest.Builder.() -> Unit) = createIdentityProvider(CreateIdentityProviderRequest.Builder().apply(block).build())

    /**
     * Creates a network settings resource that can be associated with a web portal. Once
     * associated with a web portal, network settings define how streaming instances will connect
     * with your specified VPC.
     */
    suspend fun createNetworkSettings(input: CreateNetworkSettingsRequest): CreateNetworkSettingsResponse

    /**
     * Creates a network settings resource that can be associated with a web portal. Once
     * associated with a web portal, network settings define how streaming instances will connect
     * with your specified VPC.
     */
    suspend fun createNetworkSettings(block: CreateNetworkSettingsRequest.Builder.() -> Unit) = createNetworkSettings(CreateNetworkSettingsRequest.Builder().apply(block).build())

    /**
     * Creates a web portal.
     */
    suspend fun createPortal(input: CreatePortalRequest): CreatePortalResponse

    /**
     * Creates a web portal.
     */
    suspend fun createPortal(block: CreatePortalRequest.Builder.() -> Unit) = createPortal(CreatePortalRequest.Builder().apply(block).build())

    /**
     * Creates a trust store that can be associated with a web portal. A trust store contains
     * certificate authority (CA) certificates. Once associated with a web portal, the browser in
     * a streaming session will recognize certificates that have been issued using any of the CAs
     * in the trust store. If your organization has internal websites that use certificates issued
     * by private CAs, you should add the private CA certificate to the trust store.
     */
    suspend fun createTrustStore(input: CreateTrustStoreRequest): CreateTrustStoreResponse

    /**
     * Creates a trust store that can be associated with a web portal. A trust store contains
     * certificate authority (CA) certificates. Once associated with a web portal, the browser in
     * a streaming session will recognize certificates that have been issued using any of the CAs
     * in the trust store. If your organization has internal websites that use certificates issued
     * by private CAs, you should add the private CA certificate to the trust store.
     */
    suspend fun createTrustStore(block: CreateTrustStoreRequest.Builder.() -> Unit) = createTrustStore(CreateTrustStoreRequest.Builder().apply(block).build())

    /**
     * Creates a user settings resource that can be associated with a web portal. Once
     * associated with a web portal, user settings control how users can transfer data between a
     * streaming session and the their local devices.
     */
    suspend fun createUserSettings(input: CreateUserSettingsRequest): CreateUserSettingsResponse

    /**
     * Creates a user settings resource that can be associated with a web portal. Once
     * associated with a web portal, user settings control how users can transfer data between a
     * streaming session and the their local devices.
     */
    suspend fun createUserSettings(block: CreateUserSettingsRequest.Builder.() -> Unit) = createUserSettings(CreateUserSettingsRequest.Builder().apply(block).build())

    /**
     * Deletes browser settings.
     */
    suspend fun deleteBrowserSettings(input: DeleteBrowserSettingsRequest): DeleteBrowserSettingsResponse

    /**
     * Deletes browser settings.
     */
    suspend fun deleteBrowserSettings(block: DeleteBrowserSettingsRequest.Builder.() -> Unit) = deleteBrowserSettings(DeleteBrowserSettingsRequest.Builder().apply(block).build())

    /**
     * Deletes the identity provider.
     */
    suspend fun deleteIdentityProvider(input: DeleteIdentityProviderRequest): DeleteIdentityProviderResponse

    /**
     * Deletes the identity provider.
     */
    suspend fun deleteIdentityProvider(block: DeleteIdentityProviderRequest.Builder.() -> Unit) = deleteIdentityProvider(DeleteIdentityProviderRequest.Builder().apply(block).build())

    /**
     * Deletes network settings.
     */
    suspend fun deleteNetworkSettings(input: DeleteNetworkSettingsRequest): DeleteNetworkSettingsResponse

    /**
     * Deletes network settings.
     */
    suspend fun deleteNetworkSettings(block: DeleteNetworkSettingsRequest.Builder.() -> Unit) = deleteNetworkSettings(DeleteNetworkSettingsRequest.Builder().apply(block).build())

    /**
     * Deletes a web portal.
     */
    suspend fun deletePortal(input: DeletePortalRequest): DeletePortalResponse

    /**
     * Deletes a web portal.
     */
    suspend fun deletePortal(block: DeletePortalRequest.Builder.() -> Unit) = deletePortal(DeletePortalRequest.Builder().apply(block).build())

    /**
     * Deletes the trust store.
     */
    suspend fun deleteTrustStore(input: DeleteTrustStoreRequest): DeleteTrustStoreResponse

    /**
     * Deletes the trust store.
     */
    suspend fun deleteTrustStore(block: DeleteTrustStoreRequest.Builder.() -> Unit) = deleteTrustStore(DeleteTrustStoreRequest.Builder().apply(block).build())

    /**
     * Deletes user settings.
     */
    suspend fun deleteUserSettings(input: DeleteUserSettingsRequest): DeleteUserSettingsResponse

    /**
     * Deletes user settings.
     */
    suspend fun deleteUserSettings(block: DeleteUserSettingsRequest.Builder.() -> Unit) = deleteUserSettings(DeleteUserSettingsRequest.Builder().apply(block).build())

    /**
     * Disassociates browser settings from a web portal.
     */
    suspend fun disassociateBrowserSettings(input: DisassociateBrowserSettingsRequest): DisassociateBrowserSettingsResponse

    /**
     * Disassociates browser settings from a web portal.
     */
    suspend fun disassociateBrowserSettings(block: DisassociateBrowserSettingsRequest.Builder.() -> Unit) = disassociateBrowserSettings(DisassociateBrowserSettingsRequest.Builder().apply(block).build())

    /**
     * Disassociates network settings from a web portal.
     */
    suspend fun disassociateNetworkSettings(input: DisassociateNetworkSettingsRequest): DisassociateNetworkSettingsResponse

    /**
     * Disassociates network settings from a web portal.
     */
    suspend fun disassociateNetworkSettings(block: DisassociateNetworkSettingsRequest.Builder.() -> Unit) = disassociateNetworkSettings(DisassociateNetworkSettingsRequest.Builder().apply(block).build())

    /**
     * Disassociates a trust store from a web portal.
     */
    suspend fun disassociateTrustStore(input: DisassociateTrustStoreRequest): DisassociateTrustStoreResponse

    /**
     * Disassociates a trust store from a web portal.
     */
    suspend fun disassociateTrustStore(block: DisassociateTrustStoreRequest.Builder.() -> Unit) = disassociateTrustStore(DisassociateTrustStoreRequest.Builder().apply(block).build())

    /**
     * Disassociates user settings from a web portal.
     */
    suspend fun disassociateUserSettings(input: DisassociateUserSettingsRequest): DisassociateUserSettingsResponse

    /**
     * Disassociates user settings from a web portal.
     */
    suspend fun disassociateUserSettings(block: DisassociateUserSettingsRequest.Builder.() -> Unit) = disassociateUserSettings(DisassociateUserSettingsRequest.Builder().apply(block).build())

    /**
     * Gets browser settings.
     */
    suspend fun getBrowserSettings(input: GetBrowserSettingsRequest): GetBrowserSettingsResponse

    /**
     * Gets browser settings.
     */
    suspend fun getBrowserSettings(block: GetBrowserSettingsRequest.Builder.() -> Unit) = getBrowserSettings(GetBrowserSettingsRequest.Builder().apply(block).build())

    /**
     * Gets the identity provider.
     */
    suspend fun getIdentityProvider(input: GetIdentityProviderRequest): GetIdentityProviderResponse

    /**
     * Gets the identity provider.
     */
    suspend fun getIdentityProvider(block: GetIdentityProviderRequest.Builder.() -> Unit) = getIdentityProvider(GetIdentityProviderRequest.Builder().apply(block).build())

    /**
     * Gets the network settings.
     */
    suspend fun getNetworkSettings(input: GetNetworkSettingsRequest): GetNetworkSettingsResponse

    /**
     * Gets the network settings.
     */
    suspend fun getNetworkSettings(block: GetNetworkSettingsRequest.Builder.() -> Unit) = getNetworkSettings(GetNetworkSettingsRequest.Builder().apply(block).build())

    /**
     * Gets the web portal.
     */
    suspend fun getPortal(input: GetPortalRequest): GetPortalResponse

    /**
     * Gets the web portal.
     */
    suspend fun getPortal(block: GetPortalRequest.Builder.() -> Unit) = getPortal(GetPortalRequest.Builder().apply(block).build())

    /**
     * Gets the service provider metadata.
     */
    suspend fun getPortalServiceProviderMetadata(input: GetPortalServiceProviderMetadataRequest): GetPortalServiceProviderMetadataResponse

    /**
     * Gets the service provider metadata.
     */
    suspend fun getPortalServiceProviderMetadata(block: GetPortalServiceProviderMetadataRequest.Builder.() -> Unit) = getPortalServiceProviderMetadata(GetPortalServiceProviderMetadataRequest.Builder().apply(block).build())

    /**
     * Gets the trust store.
     */
    suspend fun getTrustStore(input: GetTrustStoreRequest): GetTrustStoreResponse

    /**
     * Gets the trust store.
     */
    suspend fun getTrustStore(block: GetTrustStoreRequest.Builder.() -> Unit) = getTrustStore(GetTrustStoreRequest.Builder().apply(block).build())

    /**
     * Gets the trust store certificate.
     */
    suspend fun getTrustStoreCertificate(input: GetTrustStoreCertificateRequest): GetTrustStoreCertificateResponse

    /**
     * Gets the trust store certificate.
     */
    suspend fun getTrustStoreCertificate(block: GetTrustStoreCertificateRequest.Builder.() -> Unit) = getTrustStoreCertificate(GetTrustStoreCertificateRequest.Builder().apply(block).build())

    /**
     * Gets user settings.
     */
    suspend fun getUserSettings(input: GetUserSettingsRequest): GetUserSettingsResponse

    /**
     * Gets user settings.
     */
    suspend fun getUserSettings(block: GetUserSettingsRequest.Builder.() -> Unit) = getUserSettings(GetUserSettingsRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of browser settings.
     */
    suspend fun listBrowserSettings(input: ListBrowserSettingsRequest): ListBrowserSettingsResponse

    /**
     * Retrieves a list of browser settings.
     */
    suspend fun listBrowserSettings(block: ListBrowserSettingsRequest.Builder.() -> Unit) = listBrowserSettings(ListBrowserSettingsRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of identity providers for a specific web portal.
     */
    suspend fun listIdentityProviders(input: ListIdentityProvidersRequest): ListIdentityProvidersResponse

    /**
     * Retrieves a list of identity providers for a specific web portal.
     */
    suspend fun listIdentityProviders(block: ListIdentityProvidersRequest.Builder.() -> Unit) = listIdentityProviders(ListIdentityProvidersRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of network settings.
     */
    suspend fun listNetworkSettings(input: ListNetworkSettingsRequest): ListNetworkSettingsResponse

    /**
     * Retrieves a list of network settings.
     */
    suspend fun listNetworkSettings(block: ListNetworkSettingsRequest.Builder.() -> Unit) = listNetworkSettings(ListNetworkSettingsRequest.Builder().apply(block).build())

    /**
     * Retrieves a list or web portals.
     */
    suspend fun listPortals(input: ListPortalsRequest): ListPortalsResponse

    /**
     * Retrieves a list or web portals.
     */
    suspend fun listPortals(block: ListPortalsRequest.Builder.() -> Unit) = listPortals(ListPortalsRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of tags for a resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves a list of tags for a resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of trust store certificates.
     */
    suspend fun listTrustStoreCertificates(input: ListTrustStoreCertificatesRequest): ListTrustStoreCertificatesResponse

    /**
     * Retrieves a list of trust store certificates.
     */
    suspend fun listTrustStoreCertificates(block: ListTrustStoreCertificatesRequest.Builder.() -> Unit) = listTrustStoreCertificates(ListTrustStoreCertificatesRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of trust stores.
     */
    suspend fun listTrustStores(input: ListTrustStoresRequest): ListTrustStoresResponse

    /**
     * Retrieves a list of trust stores.
     */
    suspend fun listTrustStores(block: ListTrustStoresRequest.Builder.() -> Unit) = listTrustStores(ListTrustStoresRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of user settings.
     */
    suspend fun listUserSettings(input: ListUserSettingsRequest): ListUserSettingsResponse

    /**
     * Retrieves a list of user settings.
     */
    suspend fun listUserSettings(block: ListUserSettingsRequest.Builder.() -> Unit) = listUserSettings(ListUserSettingsRequest.Builder().apply(block).build())

    /**
     * Adds or overwrites one or more tags for the specified resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds or overwrites one or more tags for the specified resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes one or more tags from the specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates browser settings.
     */
    suspend fun updateBrowserSettings(input: UpdateBrowserSettingsRequest): UpdateBrowserSettingsResponse

    /**
     * Updates browser settings.
     */
    suspend fun updateBrowserSettings(block: UpdateBrowserSettingsRequest.Builder.() -> Unit) = updateBrowserSettings(UpdateBrowserSettingsRequest.Builder().apply(block).build())

    /**
     * Updates the identity provider.
     */
    suspend fun updateIdentityProvider(input: UpdateIdentityProviderRequest): UpdateIdentityProviderResponse

    /**
     * Updates the identity provider.
     */
    suspend fun updateIdentityProvider(block: UpdateIdentityProviderRequest.Builder.() -> Unit) = updateIdentityProvider(UpdateIdentityProviderRequest.Builder().apply(block).build())

    /**
     * Updates network settings.
     */
    suspend fun updateNetworkSettings(input: UpdateNetworkSettingsRequest): UpdateNetworkSettingsResponse

    /**
     * Updates network settings.
     */
    suspend fun updateNetworkSettings(block: UpdateNetworkSettingsRequest.Builder.() -> Unit) = updateNetworkSettings(UpdateNetworkSettingsRequest.Builder().apply(block).build())

    /**
     * Updates a web portal.
     */
    suspend fun updatePortal(input: UpdatePortalRequest): UpdatePortalResponse

    /**
     * Updates a web portal.
     */
    suspend fun updatePortal(block: UpdatePortalRequest.Builder.() -> Unit) = updatePortal(UpdatePortalRequest.Builder().apply(block).build())

    /**
     * Updates the trust store.
     */
    suspend fun updateTrustStore(input: UpdateTrustStoreRequest): UpdateTrustStoreResponse

    /**
     * Updates the trust store.
     */
    suspend fun updateTrustStore(block: UpdateTrustStoreRequest.Builder.() -> Unit) = updateTrustStore(UpdateTrustStoreRequest.Builder().apply(block).build())

    /**
     * Updates the user settings.
     */
    suspend fun updateUserSettings(input: UpdateUserSettingsRequest): UpdateUserSettingsResponse

    /**
     * Updates the user settings.
     */
    suspend fun updateUserSettings(block: UpdateUserSettingsRequest.Builder.() -> Unit) = updateUserSettings(UpdateUserSettingsRequest.Builder().apply(block).build())
}
